/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.subscription.quartz;

import com.becon.opencelium.backend.database.mysql.entity.ExtraOps;
import com.becon.opencelium.backend.database.mysql.service.ExtraOpsService;
import com.becon.opencelium.backend.subscription.enums.ExtraOpsStatus;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ExtraOpsJob
extends QuartzJobBean {
    private final ExtraOpsService extraOpsService;

    public ExtraOpsJob(@Qualifier(value="extraOpsServiceImp") ExtraOpsService extraOpsService) {
        this.extraOpsService = extraOpsService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        long extraOpsId = (Long)context.getJobDetail().getJobDataMap().get((Object)"extraOpsId");
        ExtraOps extraOps = (ExtraOps)this.extraOpsService.findById(extraOpsId).orElseThrow(() -> new RuntimeException("Extra Ops " + extraOpsId + " Not Found"));
        extraOps.setStatus(ExtraOpsStatus.EXPIRED);
        this.extraOpsService.save(extraOps);
    }
}

