/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.impl;

import com.becon.opencelium.backend.scriptengine.Language;
import com.becon.opencelium.backend.scriptengine.LanguageType;
import com.becon.opencelium.backend.scriptengine.ScriptEngine;
import com.becon.opencelium.backend.scriptengine.ScriptEngineProvider;
import com.becon.opencelium.backend.scriptengine.ScriptEngineType;
import com.becon.opencelium.backend.scriptengine.ScriptExecutionManager;
import com.becon.opencelium.backend.scriptengine.engines.PolyglotEngine;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ScriptExecutionManagerImpl
implements ScriptExecutionManager {
    private final ScriptEngineProvider scriptEngineProvider;

    public ScriptExecutionManagerImpl(ScriptEngineProvider scriptEngineProvider) {
        this.scriptEngineProvider = scriptEngineProvider;
    }

    private Optional<ScriptEngine> resolveEngine(Language lang) {
        Optional engineOpt = this.scriptEngineProvider.provide(lang);
        if (engineOpt.isPresent() && lang.getEngine() == ScriptEngineType.POLYGOT_ENGINE) {
            PolyglotEngine polyglotEngine = (PolyglotEngine)engineOpt.get();
            polyglotEngine.setLanguageType(lang.getLanguage());
            return Optional.of(polyglotEngine);
        }
        return engineOpt;
    }

    public Optional<ScriptEngine> resolveEngine(LanguageType lang) {
        return this.resolveEngine(new Language(lang, lang.getDefaultEngine()));
    }
}

