/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.external.polyglotservice;

import com.becon.opencelium.backend.proto.ScriptRequest;
import com.becon.opencelium.backend.proto.ScriptResult;
import com.becon.opencelium.backend.scriptengine.external.polyglotservice.GrpcClientConnectConfigurer;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PolyglotServiceGRPCClient {
    private static final Logger log = LoggerFactory.getLogger(PolyglotServiceGRPCClient.class);
    private static final int MAX_RETRY_ATTEMPTS = 2;
    private final GrpcClientConnectConfigurer configurer;

    public PolyglotServiceGRPCClient(GrpcClientConnectConfigurer configurer) {
        this.configurer = configurer;
    }

    public ScriptResult execute(ScriptRequest request) {
        int attempts = 0;
        StatusRuntimeException lastException = null;
        while (attempts < 2) {
            try {
                log.debug("Executing script (attempt {})", (Object)(attempts + 1));
                return this.configurer.getBlockingStub().execute(request);
            }
            catch (StatusRuntimeException e) {
                lastException = e;
                if (this.isRecoverableError(e) && ++attempts < 2) {
                    log.warn("Recoverable gRPC error on attempt {}: {}. Resetting channel and retrying...", (Object)attempts, (Object)e.getStatus());
                    this.configurer.resetChannel();
                    try {
                        Thread.sleep(100L * (long)attempts);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                log.error("Non-recoverable gRPC error or max attempts reached: {}", (Object)e.getStatus());
                break;
            }
        }
        throw new RuntimeException("Failed to execute script after " + attempts + " attempts", lastException);
    }

    public boolean isUp() {
        if (!this.configurer.isEnabled()) {
            return false;
        }
        try {
            boolean isServing;
            HealthCheckRequest request = HealthCheckRequest.newBuilder().build();
            HealthCheckResponse response = this.configurer.getHealthStub().check(request);
            boolean bl = isServing = response.getStatus() == HealthCheckResponse.ServingStatus.SERVING;
            if (!isServing) {
                log.debug("Service health check returned: {}", (Object)response.getStatus());
            }
            return isServing;
        }
        catch (StatusRuntimeException e) {
            log.debug("Health check failed: {} - {}", (Object)e.getStatus().getCode(), (Object)e.getMessage());
            if (this.isRecoverableError(e)) {
                this.configurer.resetChannel();
            }
            return false;
        }
        catch (Exception e) {
            log.debug("Health check failed with unexpected error: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isRecoverableError(StatusRuntimeException e) {
        Status.Code code = e.getStatus().getCode();
        return code == Status.Code.UNAVAILABLE || code == Status.Code.DEADLINE_EXCEEDED || code == Status.Code.CANCELLED || code == Status.Code.UNKNOWN;
    }
}

