/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.user;

import com.becon.opencelium.backend.database.mysql.entity.RoleHasPermission;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.resource.user.ComponentResource;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Resource
public class UserRoleResource {
    private int groupId;
    private String name;
    private String description;
    private String icon;
    private List<ComponentResource> components = new ArrayList();
    private final String imagePath = "./storage/files/";

    public UserRoleResource(UserRole userRole) {
        this.groupId = userRole.getId();
        this.name = userRole.getName();
        this.description = userRole.getDescription();
        if (userRole.getIcon() != null) {
            this.icon = "imagePath" + userRole.getIcon();
        }
        this.components = userRole.getComponents().stream().map(RoleHasPermission::getComponent).collect(Collectors.toSet()).stream().map(component -> new ComponentResource(component, this.groupId)).collect(Collectors.toList());
    }

    public UserRoleResource(int groupId) {
        this.groupId = groupId;
    }

    public UserRoleResource() {
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<ComponentResource> getComponents() {
        return this.components;
    }

    public void setComponents(List<ComponentResource> components) {
        this.components = components;
    }
}

