/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.user;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.resource.user.UserDetailResource;
import com.becon.opencelium.backend.resource.user.UserRoleResource;
import com.becon.opencelium.backend.resource.user.WidgetSettingResource;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Resource
public class UserResource {
    private int userId;
    private String email;
    private String username;
    private boolean totpEnabled;
    private UserRoleResource userGroup;
    private UserDetailResource userDetail;
    private List<WidgetSettingResource> widgetSettings;

    public UserResource() {
    }

    public UserResource(User user) {
        this.userId = user.getId();
        this.email = user.getEmail();
        this.username = user.getUsername();
        this.totpEnabled = user.getTotpSecretKey() != null;
        this.userGroup = new UserRoleResource(user.getUserRole());
        this.userDetail = new UserDetailResource(user.getUserDetail());
        this.widgetSettings = user.getWidgetSettings().stream().map(WidgetSettingResource::new).collect(Collectors.toList());
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isTotpEnabled() {
        return this.totpEnabled;
    }

    public void setTotpEnabled(boolean totpEnabled) {
        this.totpEnabled = totpEnabled;
    }

    public UserRoleResource getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(UserRoleResource userRole) {
        this.userGroup = userRole;
    }

    public UserDetailResource getUserDetail() {
        return this.userDetail;
    }

    public void setUserDetail(UserDetailResource userDetail) {
        this.userDetail = userDetail;
    }

    public List<WidgetSettingResource> getWidgetSettings() {
        return this.widgetSettings;
    }

    public void setWidgetSettings(List<WidgetSettingResource> widgetSettings) {
        this.widgetSettings = widgetSettings;
    }
}

