/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.quartz;

import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.execution.ConnectionExecutor;
import com.becon.opencelium.backend.execution.logger.LogMessage;
import com.becon.opencelium.backend.execution.logger.OcLogger;
import com.becon.opencelium.backend.execution.logger.msg.ExecutionLog;
import com.becon.opencelium.backend.execution.service.ExecutionObjectService;
import com.becon.opencelium.backend.execution.service.ExecutionObjectServiceImp;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.quartz.QuartzJobScheduler;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.execution.ExecutionObj;
import java.util.Map;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class JobExecutor
extends QuartzJobBean
implements InterruptableJob {
    private final ExecutionObjectService executionObjectService;
    private final SubscriptionService subscriptionService;
    private final WebSocketNotificationService notificationService;
    private final Logger logger = LoggerFactory.getLogger(JobExecutor.class);
    private volatile Thread thread;

    public JobExecutor(@Qualifier(value="executionObjectServiceImp") ExecutionObjectServiceImp executionObjectService, @Qualifier(value="subscriptionServiceImpl") SubscriptionService subscriptionService, WebSocketNotificationService notificationService) {
        this.executionObjectService = executionObjectService;
        this.subscriptionService = subscriptionService;
        this.notificationService = notificationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal(JobExecutionContext context) {
        this.thread = Thread.currentThread();
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        Subscription activeSub = this.subscriptionService.getActiveSubs();
        if (!this.subscriptionService.isValid(activeSub)) {
            this.logger.warn("Subscription is not valid");
            jobDataMap.put("licenseIsValid", false);
            return;
        }
        jobDataMap.put("licenseIsValid", true);
        long execId = jobDataMap.getLong("execId");
        long connectionId = jobDataMap.getLong("connectionId");
        boolean debugMode = jobDataMap.getBoolean("debugMode");
        String timestamp = jobDataMap.getString("timestamp");
        QuartzJobScheduler.ScheduleData data = (QuartzJobScheduler.ScheduleData)jobDataMap.get((Object)"data");
        if (data == null) {
            data = this.getData(jobDataMap);
            jobDataMap.put("data", (Object)data);
        }
        int schedulerId = data.getScheduleId();
        try {
            ExecutionObj executionObj = this.executionObjectService.buildObj(data);
            OcLogger executionLogger = new OcLogger(data.getExecType(), debugMode, (LogMessage)new ExecutionLog(), connectionId, timestamp, execId);
            ConnectionExecutor executor = new ConnectionExecutor(executionObj, executionLogger, data.getRules());
            long startTime = System.currentTimeMillis();
            try {
                executionLogger.logAndSend(String.format("phase=EXECUTION_START id=%d connectionId=%d schedulerId=%d", execId, connectionId, schedulerId));
                executor.start();
            }
            catch (Throwable throwable) {
                executionLogger.logAndSend(String.format("phase=EXECUTION_END id=%d connectionId=%d schedulerId=%d", execId, connectionId, schedulerId));
                executionLogger.close();
                context.put((Object)"operationsEx", (Object)executor.getOperations());
                throw throwable;
            }
            executionLogger.logAndSend(String.format("phase=EXECUTION_END id=%d connectionId=%d schedulerId=%d", execId, connectionId, schedulerId));
            executionLogger.close();
            context.put((Object)"operationsEx", (Object)executor.getOperations());
            String connectionName = executionObj.getConnection().getConnectionName();
            if (connectionName != null && !connectionName.contains("!*test_connection_") && data.getExecType() != QuartzJobScheduler.TriggerType.SUPPORT_FILE) {
                long operationUsage = executor.getOperations().stream().mapToInt(o -> o.getRequests().size()).sum();
                this.logger.info("Operation usage for Connection {} is {}", (Object)connectionName, (Object)operationUsage);
                this.subscriptionService.updateUsage(activeSub.getId(), executionObj.getConnection(), operationUsage, startTime);
            }
        }
        catch (ThreadDeath executionObj) {
        }
        catch (Exception e) {
            ErrorResource message = new ErrorResource(e, HttpStatus.INTERNAL_SERVER_ERROR);
            this.notificationService.send(connectionId, (Object)message);
            throw e;
        }
        finally {
            this.thread = null;
        }
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private QuartzJobScheduler.ScheduleData getData(JobDataMap jobDataMap) {
        Map queryParam = (Map)jobDataMap.getOrDefault((Object)"queryParams", null);
        int schedulerId = jobDataMap.getIntValue("schedulerId");
        String execType = jobDataMap.get((Object)"executionType").toString();
        QuartzJobScheduler.TriggerType triggerType = execType.equals("scheduler") ? QuartzJobScheduler.TriggerType.SCHEDULER : QuartzJobScheduler.TriggerType.WEBHOOK;
        return new QuartzJobScheduler.ScheduleData(schedulerId, triggerType, queryParam);
    }
}

