/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.postfix;

import com.becon.opencelium.backend.ocel.operator.Operator;
import com.becon.opencelium.backend.ocel.operator.OperatorUtils;
import com.becon.opencelium.backend.ocel.postfix.PostfixNotationConvertor;
import com.becon.opencelium.backend.ocel.token.Token;
import com.becon.opencelium.backend.ocel.token.TokenType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;

public class PostfixNotationConvertor {
    private static final PostfixNotationConvertor INSTANCE = new PostfixNotationConvertor();

    private PostfixNotationConvertor() {
    }

    public Queue<Token> toPostfix(List<Token> tokens) {
        LinkedList<Token> output = new LinkedList<Token>();
        Stack<Token> operators = new Stack<Token>();
        for (Token token : tokens) {
            switch (1.$SwitchMap$com$becon$opencelium$backend$ocel$token$TokenType[token.getType().ordinal()]) {
                case 1: {
                    operators.push(token);
                    break;
                }
                case 2: {
                    Token top;
                    while (!operators.empty() && (top = (Token)operators.pop()).getType() == TokenType.OPERATOR) {
                        output.add(top);
                    }
                    break;
                }
                case 3: {
                    Operator topOperator;
                    Token top;
                    Operator operator = OperatorUtils.getOperator((String)token.getLexeme());
                    while (!operators.empty() && (top = (Token)operators.peek()).getType() == TokenType.OPERATOR && (topOperator = OperatorUtils.getOperator((String)top.getLexeme())).getPrecedence() >= operator.getPrecedence()) {
                        operators.pop();
                        output.add(top);
                    }
                    operators.push(token);
                    break;
                }
                case 4: {
                    output.add(token);
                    break;
                }
                case 5: {
                    List parameters = token.getFunctionParameters();
                    ArrayList reOrderedParams = new ArrayList(parameters.size());
                    for (List parameter : parameters) {
                        Queue postfixParams = this.toPostfix(parameter);
                        reOrderedParams.add(new ArrayList(postfixParams));
                    }
                    token.setFunctionParameters(reOrderedParams);
                    output.add(token);
                }
            }
        }
        while (!operators.empty()) {
            output.add((Token)operators.pop());
        }
        return output;
    }

    public static PostfixNotationConvertor getInstance() {
        return INSTANCE;
    }
}

