/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel.common;

import com.becon.opencelium.backend.ocel.exception.ValueParseException;
import com.becon.opencelium.backend.ocel.operand.OperandUtils;
import com.becon.opencelium.backend.ocel.utils.Utils;
import com.becon.opencelium.backend.ocel.utils.ValueUtils;
import java.util.ArrayList;
import java.util.List;

public class RawValueParser {
    private static final RawValueParser INSTANCE = new RawValueParser();

    private RawValueParser() {
    }

    public Object parse(String val) throws ValueParseException {
        if (val == null) {
            return null;
        }
        if ("null".equals(val = val.trim())) {
            return null;
        }
        if ("true".equals(val) || "false".equals(val)) {
            return Boolean.parseBoolean(val);
        }
        if (val.startsWith("\"") && val.endsWith("\"")) {
            return val.substring(1, val.length() - 1);
        }
        if (val.startsWith("'") && val.endsWith("'")) {
            return val.substring(1, val.length() - 1);
        }
        if (ValueUtils.isNumberStr((String)val)) {
            return Double.valueOf(val);
        }
        if (val.startsWith("[") && val.endsWith("]")) {
            List lines = Utils.splitByOuterCommas((String)val.substring(1, val.length() - 1));
            return this.parseList(lines.toArray(new String[0]));
        }
        if (OperandUtils.checkTypeAvailability((String)val)) {
            return val;
        }
        throw ValueParseException.unknownOperandValue((String)val);
    }

    private Object parseList(String[] elements) throws ValueParseException {
        ArrayList<Object> parsedList = new ArrayList<Object>();
        if (elements.length == 1 && elements[0].isEmpty()) {
            return parsedList;
        }
        for (String element : elements) {
            parsedList.add(this.parse(element));
        }
        return parsedList;
    }

    public static RawValueParser getInstance() {
        return INSTANCE;
    }
}

