/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel;

import com.becon.opencelium.backend.ocel.ShallowEvaluator;
import com.becon.opencelium.backend.ocel.ShallowEvaluatorFactory;
import com.becon.opencelium.backend.ocel.ShallowEvaluatorType;
import com.becon.opencelium.backend.ocel.Validator;
import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.ocel.operand.OperandUtils;
import com.becon.opencelium.backend.ocel.operator.Arity;
import com.becon.opencelium.backend.ocel.operator.Operator;
import com.becon.opencelium.backend.ocel.operator.OperatorUtils;
import com.becon.opencelium.backend.ocel.token.Token;
import com.becon.opencelium.backend.ocel.token.TokenType;
import com.becon.opencelium.backend.ocel.token.Tokenizer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Validator {
    private final ShallowEvaluator shallowEvaluator;

    private Validator(ShallowEvaluatorType shallowEvaluatorType) {
        this.shallowEvaluator = ShallowEvaluatorFactory.get((ShallowEvaluatorType)shallowEvaluatorType);
    }

    public static Validator defaultValidator() {
        return new Validator(ShallowEvaluatorType.POSTFIX);
    }

    public static Validator withCustomShallowEvaluator(ShallowEvaluatorType type) {
        return new Validator(type);
    }

    public List<Token> validateAndTokenize(String expression) throws InvalidExpressionException {
        try {
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw InvalidExpressionException.emptyExpression();
            }
            List tokens = Tokenizer.splitTokens((String)expression);
            this.firstLevelCheck(tokens);
            this.secondLevelCheck(tokens);
            return tokens;
        }
        catch (InvalidExpressionException e) {
            throw e;
        }
        catch (Exception e) {
            throw InvalidExpressionException.unexpectedException((Exception)e);
        }
    }

    public void validate(String expression) throws InvalidExpressionException {
        try {
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw InvalidExpressionException.emptyExpression();
            }
            List tokens = Tokenizer.splitTokens((String)expression);
            this.firstLevelCheck(tokens);
            this.secondLevelCheck(tokens);
        }
        catch (InvalidExpressionException e) {
            throw e;
        }
        catch (Exception e) {
            throw InvalidExpressionException.unexpectedException((Exception)e);
        }
    }

    public boolean isValid(String expression) {
        try {
            this.validate(expression);
            return true;
        }
        catch (InvalidExpressionException e) {
            return false;
        }
    }

    private void firstLevelCheck(List<Token> tokens) throws InvalidExpressionException {
        int depth = 0;
        block7: for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            switch (1.$SwitchMap$com$becon$opencelium$backend$ocel$token$TokenType[token.getType().ordinal()]) {
                case 1: {
                    ++depth;
                    continue block7;
                }
                case 2: {
                    if (--depth >= 0) continue block7;
                    throw InvalidExpressionException.invalidParentheses();
                }
                case 3: {
                    if (OperandUtils.isOperand((String)token.getLexeme())) continue block7;
                    throw InvalidExpressionException.invalidTokenFound((String)token.getLexeme());
                }
                case 4: {
                    Operator operator = OperatorUtils.getOperator((String)token.getLexeme());
                    if (!(operator.getArity() == Arity.UNARY ? (operator.isLeftSided() ? this.insufficientNeighbor(tokens, i, true) : this.insufficientNeighbor(tokens, i, false)) : operator.getArity() == Arity.BINARY && (this.insufficientNeighbor(tokens, i, true) || this.insufficientNeighbor(tokens, i, false)))) continue block7;
                    throw InvalidExpressionException.insufficientOperand((String)token.getLexeme());
                }
                case 5: {
                    List parameters = token.getFunctionParameters();
                    for (List parameter : parameters) {
                        this.firstLevelCheck(parameter);
                    }
                    continue block7;
                }
            }
        }
        if (depth != 0) {
            throw InvalidExpressionException.invalidParentheses();
        }
    }

    private boolean insufficientNeighbor(List<Token> tokens, int i, boolean right) {
        return right ? i >= tokens.size() - 1 || tokens.get(i + 1).getType() != TokenType.OPEN_PARENTHESES && tokens.get(i + 1).getType() != TokenType.OPERAND && tokens.get(i + 1).getType() != TokenType.FUNCTION && !OperatorUtils.isLeftSidedOperator((String)tokens.get(i + 1).getLexeme()) : i <= 0 || tokens.get(i - 1).getType() != TokenType.CLOSE_PARENTHESES && tokens.get(i - 1).getType() != TokenType.OPERAND && tokens.get(i - 1).getType() != TokenType.FUNCTION && !OperatorUtils.isRightSidedOperator((String)tokens.get(i - 1).getLexeme());
    }

    private void secondLevelCheck(List<Token> tokens) throws InvalidExpressionException {
        this.shallowEvaluator.check(tokens);
    }
}

