/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.ocel;

import com.becon.opencelium.backend.database.mongodb.entity.ConditionMng;
import com.becon.opencelium.backend.database.mongodb.entity.StatementMng;
import com.becon.opencelium.backend.ocel.exception.ErrorCode;
import com.becon.opencelium.backend.ocel.exception.InvalidExpressionException;
import com.becon.opencelium.backend.ocel.operator.Arity;
import com.becon.opencelium.backend.ocel.operator.Operator;
import com.becon.opencelium.backend.ocel.operator.OperatorEnum;
import com.becon.opencelium.backend.ocel.operator.OperatorFactory;
import com.becon.opencelium.backend.ocel.token.Token;
import com.becon.opencelium.backend.ocel.token.TokenType;
import com.becon.opencelium.backend.ocel.token.Tokenizer;
import com.becon.opencelium.backend.ocel.utils.ReferenceUtils;
import com.becon.opencelium.backend.ocel.utils.ValueUtils;
import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import io.micrometer.common.util.StringUtils;
import java.util.List;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class OCExpressionHelper {
    public static String buildExp(ConditionMng condition) {
        OperatorEnum operatorEnum;
        StatementMng leftStatement = condition.getLeftStatement();
        StatementMng rightStatement = condition.getRightStatement();
        String op = condition.getRelationalOperator();
        if (StringUtils.isBlank((String)op)) {
            op = "for";
        }
        if (Objects.isNull(operatorEnum = OperatorEnum.fromName((String)op))) {
            return null;
        }
        if (operatorEnum == OperatorEnum.FOR || operatorEnum == OperatorEnum.FOR_IN) {
            return operatorEnum.getName() + " " + OCExpressionHelper.buildOperand((StatementMng)leftStatement, (String)OCExpressionHelper.rpv((StatementMng)rightStatement));
        }
        if (operatorEnum == OperatorEnum.SPLIT_STRING) {
            return OCExpressionHelper.buildOperand((StatementMng)leftStatement, (String)OCExpressionHelper.rpv((StatementMng)rightStatement)) + " " + operatorEnum.getName() + " " + OCExpressionHelper.buildOperand((StatementMng)rightStatement);
        }
        Operator operator = OperatorFactory.getOperator((OperatorEnum)operatorEnum);
        if (operator == null) {
            return null;
        }
        if (operator.getArity() == Arity.UNARY) {
            if (operator.isLeftSided()) {
                return operatorEnum.getName() + " " + OCExpressionHelper.buildOperand((StatementMng)rightStatement);
            }
            return OCExpressionHelper.buildOperand((StatementMng)leftStatement, (String)OCExpressionHelper.rpv((StatementMng)rightStatement)) + " " + operatorEnum.getName();
        }
        if (operatorEnum == OperatorEnum.IS_TYPE_OF) {
            return OCExpressionHelper.buildOperand((StatementMng)leftStatement, (String)OCExpressionHelper.rpv((StatementMng)rightStatement)) + " " + operatorEnum.getName() + " " + OCExpressionHelper.buildOperand((StatementMng)rightStatement, (boolean)false);
        }
        return OCExpressionHelper.buildOperand((StatementMng)leftStatement, (String)OCExpressionHelper.rpv((StatementMng)rightStatement)) + " " + operatorEnum.getName() + " " + OCExpressionHelper.buildOperand((StatementMng)rightStatement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateLoopExp(String exp) {
        List tokens = Tokenizer.splitTokens((String)exp);
        if (tokens.size() == 2) {
            if (((Token)tokens.get(0)).getType() != TokenType.OPERATOR || ((Token)tokens.get(1)).getType() != TokenType.OPERAND) throw InvalidExpressionException.invalidLoopExpression((String)exp);
            OperatorEnum operatorEnum = OperatorEnum.fromName((String)((Token)tokens.get(0)).getLexeme());
            if (operatorEnum == OperatorEnum.FOR || operatorEnum == OperatorEnum.FOR_IN) return;
            if (!ReferenceUtils.isReference((String)((Token)tokens.get(1)).getLexeme()) && !ValueUtils.isArray((String)((Token)tokens.get(1)).getLexeme())) throw InvalidExpressionException.invalidLoopExpression((String)exp);
            throw new InvalidExpressionException(ErrorCode.INVALID_LOOP_TYPE, "Loop type is incorrect. Did you mean 'for %s'?".formatted(((Token)tokens.get(1)).getLexeme()));
        }
        if (tokens.size() != 3) throw InvalidExpressionException.invalidLoopExpression((String)exp);
        OperatorEnum operatorEnum = OperatorEnum.fromName((String)((Token)tokens.get(1)).getLexeme());
        if (operatorEnum != OperatorEnum.SPLIT_STRING) {
            if (!ReferenceUtils.isReference((String)((Token)tokens.get(0)).getLexeme()) && !ValueUtils.isString((String)((Token)tokens.get(0)).getLexeme()) || !ReferenceUtils.isReference((String)((Token)tokens.get(2)).getLexeme()) && !ValueUtils.isString((String)((Token)tokens.get(2)).getLexeme())) throw InvalidExpressionException.invalidLoopExpression((String)exp);
            throw new InvalidExpressionException(ErrorCode.INVALID_LOOP_TYPE, "Loop type is incorrect. Did you mean '%s SplitString %s'?".formatted(((Token)tokens.get(0)).getLexeme(), ((Token)tokens.get(2)).getLexeme()));
        }
        if (!ReferenceUtils.isReference((String)((Token)tokens.get(0)).getLexeme()) && !ValueUtils.isString((String)((Token)tokens.get(0)).getLexeme())) {
            throw new InvalidExpressionException(ErrorCode.INVALID_TOKEN_FOUND, "'%s' is not valid left operand for SplitString".formatted(((Token)tokens.get(0)).getLexeme()));
        }
        if (ReferenceUtils.isReference((String)((Token)tokens.get(2)).getLexeme()) || ValueUtils.isString((String)((Token)tokens.get(2)).getLexeme())) return;
        throw new InvalidExpressionException(ErrorCode.INVALID_TOKEN_FOUND, "'%s' is not valid right operand for SplitString".formatted(((Token)tokens.get(2)).getLexeme()));
    }

    private static String buildOperand(StatementMng statement, String rightPropertyValue) {
        return OCExpressionHelper.buildOperand((StatementMng)statement, (boolean)false, (String)rightPropertyValue);
    }

    private static String buildOperand(StatementMng statement, boolean quoted, String rpv) {
        if (Objects.isNull(statement)) {
            return "";
        }
        if (StringUtils.isBlank((String)statement.getType()) && StringUtils.isBlank((String)statement.getColor())) {
            if (!quoted) {
                return statement.getField();
            }
            return "'" + statement.getField() + "'";
        }
        return "{%" + PathAndReferenceUtility.rebuildReference((String)statement.getColor(), (String)statement.getType(), (String)statement.getField()) + (String)(StringUtils.isBlank((String)rpv) ? "" : "." + rpv) + "%}";
    }

    private static String buildOperand(StatementMng statement, boolean quoted) {
        return OCExpressionHelper.buildOperand((StatementMng)statement, (boolean)quoted, (String)"");
    }

    private static String buildOperand(StatementMng statement) {
        return OCExpressionHelper.buildOperand((StatementMng)statement, (boolean)true, (String)"");
    }

    private static String rpv(StatementMng statement) {
        return statement == null ? null : statement.getRightPropertyValue();
    }
}

