/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.utils;

import com.becon.opencelium.backend.database.mongodb.entity.ConnectorMng;
import com.becon.opencelium.backend.database.mongodb.service.FieldBindingMngService;
import com.becon.opencelium.backend.database.mysql.entity.Category;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.database.mysql.service.CategoryService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.database.mysql.service.RequestDataService;
import com.becon.opencelium.backend.invoker.entity.RequiredData;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.mapper.mongo.FieldBindingMngMapper;
import com.becon.opencelium.backend.mapper.mongo.MethodMngMapper;
import com.becon.opencelium.backend.mapper.mongo.OperatorMngMapper;
import com.becon.opencelium.backend.mapper.mysql.ConnectorMapper;
import com.becon.opencelium.backend.mapper.mysql.ConnectorResourceMapper;
import com.becon.opencelium.backend.mapper.mysql.EnhancementMapper;
import com.becon.opencelium.backend.mapper.mysql.RequestDataMapper;
import com.becon.opencelium.backend.mapper.mysql.invoker.InvokerMapper;
import com.becon.opencelium.backend.resource.CategoryResponseDTO;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connection.binding.EnhancementDTO;
import com.becon.opencelium.backend.resource.connection.binding.FieldBindingDTO;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.resource.connector.InvokerDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.ReportingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

@Mapper(componentModel="spring", unmappedSourcePolicy=ReportingPolicy.IGNORE, unmappedTargetPolicy=ReportingPolicy.IGNORE, uses={OperatorMngMapper.class, MethodMngMapper.class})
@Named(value="helperMapper")
public abstract class HelperMapper {
    @Autowired
    @Lazy
    @Qualifier(value="connectorServiceImp")
    private ConnectorService connectorService;
    @Autowired
    @Qualifier(value="enhancementServiceImp")
    private EnhancementService enhancementService;
    @Autowired
    @Qualifier(value="invokerServiceImp")
    private InvokerService invokerService;
    @Autowired
    @Qualifier(value="requestDataServiceImp")
    private RequestDataService requestDataService;
    @Autowired
    @Qualifier(value="fieldBindingMngServiceImp")
    @Lazy
    private FieldBindingMngService fieldBindingMngService;
    @Autowired
    private InvokerMapper invokerMapper;
    @Autowired
    @Lazy
    private ConnectorMapper connectorMapper;
    @Autowired
    @Lazy
    private EnhancementMapper enhancementMapper;
    @Autowired
    @Lazy
    private FieldBindingMngMapper fieldBindingMngMapper;
    @Autowired
    @Lazy
    private RequestDataMapper requestDataMapper;
    @Autowired
    @Lazy
    private ConnectorResourceMapper connectorResourceMapper;
    @Autowired
    @Qualifier(value="categoryServiceImp")
    @Lazy
    private CategoryService categoryService;

    @Named(value="toConnectorDTO")
    public ConnectorDTO toConnectorDTO(ConnectorMng connectorMng) {
        ConnectorDTO connectorDTO = this.toDTO(connectorMng);
        if (connectorDTO == null) {
            return null;
        }
        Connector connector = this.connectorService.findById(connectorDTO.getConnectorId().intValue()).orElse(null);
        if (connector != null) {
            connectorDTO.setIcon(connector.getIcon());
            connectorDTO.setTimeout(connector.getTimeout());
            connectorDTO.setSslCert(connector.isSslValidation());
            connectorDTO.setInvoker(this.getInvokerDTO(connector.getInvoker()));
        }
        return connectorDTO;
    }

    @Named(value="getConnectorDTOById")
    public ConnectorDTO getConnectorDTOById(int id) {
        return this.connectorMapper.toDTO((Connector)this.connectorService.findById(id).orElse(null));
    }

    @Named(value="getConnectorResourceById")
    public ConnectorResource getConnectorResourceById(int id) {
        return this.connectorResourceMapper.toDTO((Connector)this.connectorService.findById(id).orElse(null));
    }

    @Named(value="getFieldBindings")
    public List<FieldBindingDTO> getFieldBindings(List<Enhancement> enhancements) {
        if (enhancements == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldBindingDTO> list = new ArrayList<FieldBindingDTO>(enhancements.size());
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Enhancement enhancement : enhancements) {
            if (enhancement.getId() != null) {
                ids.add(enhancement.getId());
                continue;
            }
            FieldBindingDTO fieldBindingDTO = new FieldBindingDTO();
            fieldBindingDTO.setEnhancement(this.enhancementMapper.toDTO(enhancement));
            list.add(fieldBindingDTO);
        }
        list.addAll(this.fieldBindingMngMapper.toDTOAll(this.fieldBindingMngService.findAllByEnhancementId(ids)));
        return list;
    }

    @Mappings(value={@Mapping(target="methods", qualifiedByName={"methodMngMapper", "toDTOAll"}), @Mapping(target="operators", qualifiedByName={"operatorMngMapper", "toDTOAll"})})
    protected abstract ConnectorDTO toDTO(ConnectorMng var1);

    @Named(value="getInvokerDTO")
    public InvokerDTO getInvokerDTO(String invoker) {
        try {
            return this.invokerMapper.toDTO(this.invokerService.findByName(invoker));
        }
        catch (Exception e) {
            return new InvokerDTO();
        }
    }

    @Named(value="processRequestData")
    public List<RequestData> processRequestData(ConnectorResource dto) {
        List requestData = this.requestDataMapper.toEntity(dto.getRequestData());
        if (requestData == null) {
            return Collections.emptyList();
        }
        Connector connector = new Connector();
        connector.setId(dto.getConnectorId());
        requestData.forEach(r -> {
            this.requestDataService.findByConnectorIdAndField(dto.getConnectorId(), r.getField()).ifPresent(data -> r.setId(data.getId()));
            r.setConnector(connector);
        });
        List requiredData = this.invokerService.findByName(dto.getInvoker().getName()).getRequiredData();
        requestData.forEach(data -> {
            String visibility = requiredData.stream().filter(d -> d.getName().equals(data.getField())).map(RequiredData::getVisibility).findFirst().orElseThrow(() -> new RuntimeException("Visibility not found while converting to entity for field:" + data.getField()));
            data.setVisibility(visibility);
        });
        return requestData;
    }

    @Named(value="getEnhancementDTOById")
    public EnhancementDTO getEnhancementDTOById(Integer id) {
        Enhancement enhancement = this.enhancementService.getById(id);
        return this.enhancementMapper.toDTO(enhancement);
    }

    @Named(value="mapCategoriesToIds")
    public Set<Integer> mapCategoriesToIds(Set<Category> categories) {
        if (categories == null) {
            return null;
        }
        return categories.stream().map(Category::getId).collect(Collectors.toSet());
    }

    @Named(value="mapParentCategory")
    public CategoryResponseDTO mapParentCategory(Category parent) {
        if (parent == null) {
            return null;
        }
        CategoryResponseDTO category = new CategoryResponseDTO();
        category.setId(parent.getId());
        category.setName(parent.getName());
        return category;
    }
}

