/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.mysql;

import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.mapper.mysql.ConnectorResourceMapper;
import com.becon.opencelium.backend.mapper.mysql.RequestDataMapper;
import com.becon.opencelium.backend.mapper.utils.HelperMapper;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.resource.connector.InvokerDTO;
import com.becon.opencelium.backend.utility.StringUtility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectorResourceMapperImpl
implements ConnectorResourceMapper {
    @Autowired
    private HelperMapper helperMapper;
    @Autowired
    private RequestDataMapper requestDataMapper;

    public ConnectorResource toDTO(Connector entity) {
        if (entity == null) {
            return null;
        }
        ConnectorResource connectorResource = new ConnectorResource();
        connectorResource.setConnectorId(entity.getId());
        connectorResource.setInvoker(this.helperMapper.getInvokerDTO(entity.getInvoker()));
        connectorResource.setRequestData(this.requestDataMapper.toDTO(entity.getRequestData()));
        connectorResource.setSslCert(entity.isSslValidation());
        connectorResource.setTitle(entity.getTitle());
        connectorResource.setDescription(entity.getDescription());
        connectorResource.setTimeout(entity.getTimeout());
        connectorResource.setIcon(StringUtility.resolveImagePath((String)entity.getIcon()));
        return connectorResource;
    }

    public Connector toEntity(ConnectorResource dto) {
        if (dto == null) {
            return null;
        }
        Connector connector = new Connector();
        connector.setId(dto.getConnectorId());
        connector.setInvoker(this.dtoInvokerName(dto));
        connector.setSslValidation(dto.isSslCert());
        connector.setTitle(dto.getTitle());
        connector.setDescription(dto.getDescription());
        connector.setTimeout(dto.getTimeout());
        connector.setIcon(StringUtility.findImageFromUrl((String)dto.getIcon()));
        connector.setRequestData(this.helperMapper.processRequestData(dto));
        return connector;
    }

    private String dtoInvokerName(ConnectorResource connectorResource) {
        if (connectorResource == null) {
            return null;
        }
        InvokerDTO invoker = connectorResource.getInvoker();
        if (invoker == null) {
            return null;
        }
        String name = invoker.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

