/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.execution;

import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.resource.execution.EnhancementEx;
import com.becon.opencelium.backend.resource.execution.FieldBindEx;
import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class FieldBindExMapper {
    private final EnhancementService enhancementService;

    public FieldBindExMapper(@Qualifier(value="enhancementServiceImp") EnhancementService enhancementService) {
        this.enhancementService = enhancementService;
    }

    public FieldBindEx toEntity(FieldBindingMng dto) {
        FieldBindEx fieldBindEx = new FieldBindEx();
        fieldBindEx.setBindId(dto.getId());
        Enhancement enhancement = this.enhancementService.getById(dto.getEnhancementId());
        EnhancementEx enhancementEx = new EnhancementEx();
        enhancementEx.setEnhanceId(dto.getEnhancementId());
        enhancementEx.setLang(enhancement.getLanguage());
        if (enhancement.getArgs() == null) {
            enhancementEx.setArgs(new HashMap());
        } else {
            List vars = PathAndReferenceUtility.splitByDelimiter((String)(enhancement.getArgs().endsWith(";") ? enhancement.getArgs().substring(0, enhancement.getArgs().length() - 1) : enhancement.getArgs()), (char)';');
            for (int i = 0; i < vars.size(); ++i) {
                vars.set(i, ((String)vars.get(i)).trim());
                if (!((String)vars.get(i)).startsWith("//")) continue;
                vars.set(i, ((String)vars.get(i)).substring(2));
            }
            HashMap args = new HashMap();
            vars.forEach(v -> {
                List split = PathAndReferenceUtility.splitByDelimiter((String)v, (char)'=');
                String key = ((String)split.get(0)).trim().split("\\s")[1];
                String value = ((String)split.get(1)).trim();
                if (!key.equals("RESULT_VAR")) {
                    args.put(key, value);
                }
            });
            enhancementEx.setScript(enhancement.getScript());
            enhancementEx.setArgs(args);
        }
        fieldBindEx.setEnhance(enhancementEx);
        return fieldBindEx;
    }

    public List<FieldBindEx> toEntityAll(List<FieldBindingMng> dtoList) {
        if (dtoList == null || dtoList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FieldBindEx> fieldBindExes = new ArrayList<FieldBindEx>();
        for (FieldBindingMng fieldBindMng : dtoList) {
            fieldBindExes.add(this.toEntity(fieldBindMng));
        }
        return fieldBindExes;
    }
}

