/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.execution;

import com.becon.opencelium.backend.database.mongodb.entity.ConnectorMng;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.enums.OpType;
import com.becon.opencelium.backend.execution.rdata.RequiredDataService;
import com.becon.opencelium.backend.execution.rdata.RequiredDataServiceImp;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.mapper.execution.OperationExMapper;
import com.becon.opencelium.backend.mapper.execution.OperatorExMapper;
import com.becon.opencelium.backend.resource.execution.ConnectorEx;
import com.becon.opencelium.backend.resource.execution.OperationDTO;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConnectorExMapper {
    private final ConnectorService connectorService;
    private final OperationExMapper operationExMapper;
    private final OperatorExMapper operatorExMapper;
    private final InvokerService invokerService;

    public ConnectorExMapper(@Qualifier(value="connectorServiceImp") ConnectorService connectorService, OperationExMapper operationExMapper, OperatorExMapper operatorExMapper, @Qualifier(value="invokerServiceImp") InvokerService invokerService) {
        this.connectorService = connectorService;
        this.operationExMapper = operationExMapper;
        this.operatorExMapper = operatorExMapper;
        this.invokerService = invokerService;
    }

    ConnectorEx toEntity(ConnectorMng dto, Long connectionId) {
        Connector connector = this.connectorService.getById(dto.getConnectorId());
        ConnectorEx connectorEx = new ConnectorEx();
        List requestData = connector.getRequestData();
        Invoker invoker = this.invokerService.findByName(connector.getInvoker());
        invoker.getRequiredData().forEach(rd -> {
            if (requestData.stream().noneMatch(rqsd -> rqsd.getField().equals(rd.getName()))) {
                requestData.add(new RequestData(rd));
            }
        });
        RequiredDataServiceImp requiredDataService = new RequiredDataServiceImp(connector, requestData, invoker.getOperations());
        requestData.forEach(arg_0 -> ConnectorExMapper.lambda$toEntity$2((RequiredDataService)requiredDataService, arg_0));
        HashMap map = new HashMap();
        requestData.forEach(r -> map.put(r.getField(), r.getValue()));
        connectorEx.setName(connector.getTitle());
        connectorEx.setSslCert(connector.isSslValidation());
        connectorEx.setInvoker(connector.getInvoker());
        connectorEx.setRequiredData(map);
        connectorEx.setId(dto.getConnectorId().intValue());
        connectorEx.setFchartId(dto.getFlowId());
        connectorEx.setMethods(this.operationExMapper.toOperationAll(dto.getMethods(), connectionId, connector.getInvoker()));
        connectorEx.setOperators(this.operatorExMapper.toEntityAll(dto.getOperators()));
        this.setPagination(connectorEx, invoker);
        return connectorEx;
    }

    private void setPagination(ConnectorEx connectorEx, Invoker invoker) {
        connectorEx.setPagination(invoker.getPagination());
        List operations = connectorEx.getMethods();
        for (OperationDTO operation : operations) {
            invoker.getOperations().stream().filter(f -> f.getName().equals(operation.getName())).findAny().ifPresentOrElse(ff -> {
                if (ff.getType().equals("page")) {
                    if (ff.getPagination() == null) {
                        operation.setPagination(invoker.getPagination());
                    } else {
                        operation.setPagination(ff.getPagination());
                    }
                    operation.setOperationType(OpType.PAGINATION);
                } else {
                    operation.setOperationType(OpType.fromValue((String)ff.getType()));
                }
            }, () -> {
                throw new RuntimeException("Method not found with name: " + operation.getName());
            });
        }
    }

    private static /* synthetic */ void lambda$toEntity$2(RequiredDataService requiredDataService, RequestData rqsd) {
        String value = requiredDataService.getValue(rqsd).orElse(null);
        rqsd.setValue(value);
    }
}

