/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker.parser;

import com.becon.opencelium.backend.enums.PageParam;
import com.becon.opencelium.backend.enums.PageParamAction;
import com.becon.opencelium.backend.factory.InvokerParserFactory;
import com.becon.opencelium.backend.invoker.entity.Body;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.entity.PageParamRule;
import com.becon.opencelium.backend.invoker.entity.Pagination;
import com.becon.opencelium.backend.invoker.entity.RequestInv;
import com.becon.opencelium.backend.invoker.entity.RequiredData;
import com.becon.opencelium.backend.invoker.entity.ResponseInv;
import com.becon.opencelium.backend.invoker.entity.ResultInv;
import com.becon.opencelium.backend.invoker.parser.InvokerParserImp;
import com.becon.opencelium.backend.invoker.parser.XMLParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InvokerParserImp {
    private static final Logger logger = LoggerFactory.getLogger(InvokerParserImp.class);
    private Document document;

    public InvokerParserImp(Document document) {
        this.document = document;
    }

    public Invoker parse() {
        return this.getInvoker(this.document.getChildNodes());
    }

    private Invoker getInvoker(NodeList nodeList) {
        Invoker invoker = new Invoker();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (Invoker)xmlDomParser.doAction("invoker", node -> {
            NodeList childNode = node.getChildNodes();
            String invokerName = this.getName(childNode);
            invoker.setName(invokerName);
            invoker.setDescription(this.getDescription(childNode));
            invoker.setHint(this.getHint(childNode));
            invoker.setIcon(this.getIcon(childNode));
            invoker.setAuthType(this.getAuthType(childNode));
            invoker.setRequiredData(this.getRequired(childNode));
            invoker.setPagination(this.getPagination(childNode));
            invoker.setOperations(this.getOperation(childNode));
            return invoker;
        });
    }

    private String getName(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("name", node -> {
            logger.info("Loading Process Started for Invoker << " + node.getTextContent() + " >>");
            return node.getTextContent();
        });
    }

    private String getDescription(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("description", Node::getTextContent);
    }

    private String getIcon(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("icon", Node::getTextContent);
    }

    private String getHint(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("hint", Node::getTextContent);
    }

    private List<RequiredData> getRequired(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (List)xmlDomParser.doAction("requiredData", node -> this.getRequestDataItems(node.getChildNodes()));
    }

    private String getAuthType(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("authType", Node::getTextContent);
    }

    private Pagination getPagination(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (Pagination)xmlDomParser.doAction("pagination", node -> new Pagination(this.getPageRules(node.getChildNodes())));
    }

    private List<FunctionInvoker> getOperation(NodeList nodeList) {
        ArrayList functionInvokers = new ArrayList();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (List)xmlDomParser.doAction("operations", node -> this.getFunctions(node.getChildNodes()));
    }

    public List<FunctionInvoker> getFunctions(NodeList nodeList) {
        ArrayList functions = new ArrayList();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (List)xmlDomParser.doAction("operation", node -> {
            FunctionInvoker function = new FunctionInvoker();
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue();
            function.setName(name);
            function.setType(type);
            function.setPagination(this.getPagination(node.getChildNodes()));
            function.setRequest(this.getRequest(node.getChildNodes()));
            function.setResponse(this.getResponse(node.getChildNodes()));
            functions.add(function);
            return functions;
        });
    }

    private RequestInv getRequest(NodeList nodeList) {
        RequestInv request = new RequestInv();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (RequestInv)xmlDomParser.doAction("request", node -> {
            String method = this.getMethod(node.getChildNodes());
            String endpoint = this.getEndpoint(node.getChildNodes());
            Map header = this.getHeader(node.getChildNodes());
            Body body = this.getBody(node.getChildNodes());
            request.setMethod(method);
            request.setEndpoint(endpoint);
            request.setHeader(header);
            request.setBody(body);
            return request;
        });
    }

    private String getMethod(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("method", Node::getTextContent);
    }

    private String getEndpoint(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (String)xmlDomParser.doAction("endpoint", Node::getTextContent);
    }

    private ResponseInv getResponse(NodeList nodeList) {
        ResponseInv response = new ResponseInv();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (ResponseInv)xmlDomParser.doAction("response", node -> {
            response.setFail(this.getResult("fail", node.getChildNodes()));
            response.setSuccess(this.getResult("success", node.getChildNodes()));
            return response;
        });
    }

    private Map<String, String> getHeader(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (Map)xmlDomParser.doAction("header", node -> this.getItem(node.getChildNodes()));
    }

    private Body getBody(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (Body)xmlDomParser.doAction("body", node -> {
            if (!node.hasAttributes() || !node.hasChildNodes()) {
                return null;
            }
            String format = node.getAttributes().getNamedItem("format").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue();
            String data = node.getAttributes().getNamedItem("data").getNodeValue();
            Map fields = this.getFields(node.getChildNodes());
            Body body = new Body();
            body.setFields(fields);
            body.setData(data);
            body.setFormat(format);
            body.setType(type);
            return body;
        });
    }

    private Map<String, Object> getFields(NodeList nodeList) {
        HashMap fields = new HashMap();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (Map)xmlDomParser.doAction("field", node -> {
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue();
            if (node.hasChildNodes() && (type.equals("object") || type.equals("array"))) {
                if (type.equals("array")) {
                    ArrayList<Object> array = new ArrayList<Object>();
                    String nodeValue = node.getTextContent().replace("\n", "").replace("\r", "").trim();
                    if (nodeValue.length() == 0) {
                        array.add(this.getFields(node.getChildNodes()));
                    } else {
                        String[] elements = nodeValue.split(",");
                        array.addAll(Arrays.asList(elements));
                    }
                    fields.put(name, array);
                } else {
                    fields.put(name, this.getFields(node.getChildNodes()));
                }
                return fields;
            }
            if (!node.hasChildNodes() && type.equals("array")) {
                fields.put(name, new ArrayList());
                return fields;
            }
            String value = node.getTextContent();
            value = value.replace("\n", "").replace("\r", "").trim();
            if (node.getTextContent().isEmpty()) {
                value = "";
            }
            if (value.equals("null")) {
                value = null;
            }
            fields.put(name, value);
            return fields;
        });
    }

    private ResultInv getResult(String resultType, NodeList nodeList) {
        ResultInv resultInv = new ResultInv();
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        return (ResultInv)xmlDomParser.doAction(resultType, node -> {
            Map header = this.getHeader(node.getChildNodes());
            Body body = this.getBody(node.getChildNodes());
            resultInv.setBody(body);
            resultInv.setHeader(header);
            resultInv.setStatus(node.getAttributes().getNamedItem("status").getNodeValue());
            return resultInv;
        });
    }

    private List<PageParamRule> getPageRules(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        LinkedList<PageParamRule> rules = new LinkedList<PageParamRule>();
        for (PageParam param : PageParam.values()) {
            PageParamRule pageParamRule = null;
            pageParamRule = (PageParamRule)xmlDomParser.doAction(param.toString(), node -> {
                PageParamRule rule = new PageParamRule();
                rule.setParam(param);
                rule.setValue(this.getValueOrDefault(param, node));
                if (node.getAttributes().getNamedItem("action") != null) {
                    rule.setAction(PageParamAction.fromString((String)node.getAttributes().getNamedItem("action").getNodeValue()));
                }
                if (node.getAttributes().getNamedItem("ref") != null) {
                    rule.setRef(node.getAttributes().getNamedItem("ref").getNodeValue());
                }
                return rule;
            });
            if (pageParamRule == null) continue;
            rules.add(pageParamRule);
        }
        logger.info("Following parameters from pagination was fetched: " + String.valueOf(rules));
        return rules;
    }

    private List<RequiredData> getRequestDataItems(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        LinkedList items = new LinkedList();
        return (List)xmlDomParser.doAction("item", node -> {
            RequiredData requiredData = new RequiredData();
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            String visibility = node.getAttributes().getNamedItem("visibility").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue();
            String value = node.getTextContent();
            requiredData.setName(name);
            requiredData.setType(type);
            requiredData.setVisibility(visibility);
            requiredData.setValue(value);
            items.add(requiredData);
            return items;
        });
    }

    private Map<String, String> getItem(NodeList nodeList) {
        InvokerParserFactory invokerParserFactory = new InvokerParserFactory();
        XMLParser xmlDomParser = invokerParserFactory.getXmlDomParser(nodeList);
        HashMap items = new HashMap();
        return (Map)xmlDomParser.doAction("item", node -> {
            String key = node.getAttributes().getNamedItem("name").getNodeValue();
            String value = node.getTextContent();
            items.put(key, value);
            return items;
        });
    }

    private String getValueOrDefault(PageParam pageParam, Node node) {
        if (node.getTextContent().isEmpty()) {
            switch (1.$SwitchMap$com$becon$opencelium$backend$enums$PageParam[pageParam.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    return "0";
                }
            }
        }
        return node.getTextContent();
    }
}

