/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker;

import com.becon.opencelium.backend.configuration.cutomizer.RestCustomizer;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.invoker.entity.Body;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.utility.Xml;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvokerRequestBuilder {
    private FunctionInvoker functionInvoker;
    private List<RequestData> requestData;
    private boolean sslCert;
    private String proxyPort;
    private String proxyHost;
    private String proxyUser;
    private String proxyPass;
    private int timeout;

    public InvokerRequestBuilder setRequestData(List<RequestData> requestData) {
        this.requestData = requestData;
        return this;
    }

    public InvokerRequestBuilder setFunction(FunctionInvoker function) {
        this.functionInvoker = function;
        return this;
    }

    public InvokerRequestBuilder setSslCert(boolean sslCert) {
        this.sslCert = sslCert;
        return this;
    }

    public InvokerRequestBuilder setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public InvokerRequestBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public InvokerRequestBuilder setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public InvokerRequestBuilder setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public InvokerRequestBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ResponseEntity<String> sendRequest() {
        String data;
        HttpMethod method = this.getMethod();
        String url = this.buildUrl();
        HttpHeaders header = this.buildHeader();
        String body = this.buildBody();
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        String contentType = "";
        if (header.containsKey((Object)"Content-Type")) {
            contentType = (String)header.get((Object)"Content-Type").get(0);
        }
        if (header.containsKey((Object)"Content-Type") && contentType.equals("application/x-www-form-urlencoded")) {
            try {
                HashMap mapData = (HashMap)new ObjectMapper().readValue(body, HashMap.class);
                mapData.forEach((arg_0, arg_1) -> ((MultiValueMap)formData).add(arg_0, arg_1));
                data = formData;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            data = body;
        }
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)header);
        if (body == null || body.equals("null")) {
            httpEntity = new HttpEntity((MultiValueMap)header);
        }
        RestTemplate restTemplate = this.createRestTemplate();
        ResponseEntity response = this.getResponseContentType(header, this.functionInvoker).toString().contains("json") ? InvokerRequestBuilder.convertToStringResponse((ResponseEntity)restTemplate.exchange(url, method, httpEntity, Object.class, new Object[0])) : restTemplate.exchange(url, method, httpEntity, String.class, new Object[0]);
        return response;
    }

    private MediaType getResponseContentType(HttpHeaders httpHeaders, FunctionInvoker functionInvoker) {
        if (functionInvoker.getResponse() != null && functionInvoker.getResponse().getSuccess() != null && functionInvoker.getResponse().getSuccess().getHeader() != null) {
            String mimeType = (String)functionInvoker.getResponse().getSuccess().getHeader().get("Content-Type");
            try {
                return MediaType.valueOf((String)mimeType);
            }
            catch (InvalidMediaTypeException e) {
                String message = " in method " + functionInvoker.getName() + ". Please set proper Content-Type in response.header";
                throw new InvalidMediaTypeException(mimeType, message);
            }
        }
        if (httpHeaders == null || httpHeaders.getContentType() == null) {
            return MediaType.APPLICATION_JSON;
        }
        return httpHeaders.getContentType();
    }

    private RestTemplate createRestTemplate() {
        RestCustomizer restCustomizer = this.proxyUser == null || this.proxyPass == null ? new RestCustomizer(this.proxyHost, this.proxyPort, this.sslCert) : new RestCustomizer(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPass, this.sslCert, this.timeout);
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[]{restCustomizer});
        return restTemplateBuilder.build();
    }

    private HttpMethod getMethod() {
        return switch (this.functionInvoker.getRequest().getMethod()) {
            case "POST" -> HttpMethod.POST;
            case "DELETE" -> HttpMethod.DELETE;
            case "PUT" -> HttpMethod.PUT;
            case "GET" -> HttpMethod.GET;
            default -> throw new RuntimeException("Http method not found");
        };
    }

    private String buildUrl() {
        String endpoint = this.functionInvoker.getRequest().getEndpoint();
        for (RequestData data : this.requestData) {
            String field = "{" + data.getField() + "}";
            if (!endpoint.contains(field)) continue;
            endpoint = endpoint.replace(field, data.getValue());
        }
        return endpoint;
    }

    private HttpHeaders buildHeader() {
        HttpHeaders httpHeaders = new HttpHeaders();
        Map header = this.functionInvoker.getRequest().getHeader();
        HashMap headerItem = new HashMap();
        header.forEach((k, v) -> {
            if (v.contains("{") && v.contains("}")) {
                String requiredField = v.replace("{", "").replace("}", "");
                String curlyValue = v;
                for (RequestData data : this.requestData) {
                    String field = "{" + data.getField() + "}";
                    if (!v.contains(field)) continue;
                    curlyValue = curlyValue.replace(field, data.getValue());
                }
                headerItem.put(k, curlyValue);
                return;
            }
            headerItem.put(k, v);
        });
        httpHeaders.setAll(headerItem);
        return httpHeaders;
    }

    private String buildBody() {
        try {
            Body body = this.functionInvoker.getRequest().getBody();
            if (body == null) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            String result = "";
            if (body.getFormat().equals("xml")) {
                Document document = this.createDocument();
                Xml transformer = new Xml(document);
                result = transformer.toString((Object)body.getFields());
            } else {
                result = objectMapper.writeValueAsString((Object)body.getFields());
            }
            for (RequestData data : this.requestData) {
                String field = "{" + data.getField() + "}";
                if (!result.contains(field)) continue;
                result = result.replace(field, data.getValue());
            }
            return result;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Document createDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException parserException) {
            parserException.printStackTrace();
            throw new RuntimeException(parserException);
        }
    }

    public static ResponseEntity<String> convertToStringResponse(ResponseEntity response) {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String json = "";
        try {
            json = ow.writeValueAsString(response.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ResponseEntity((Object)json, (MultiValueMap)response.getHeaders(), response.getStatusCode());
    }
}

