/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.connection.service;

import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.exception.ConnectionNotFoundException;
import com.becon.opencelium.backend.gc.connection.ConnectionForGC;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConnectionGCService {
    private final ConnectionService connectionService;
    private final ConnectionMngService connectionMngService;

    public ConnectionGCService(@Qualifier(value="connectionServiceImp") ConnectionService connectionService, @Qualifier(value="connectionMngServiceImp") ConnectionMngService connectionMngService) {
        this.connectionService = connectionService;
        this.connectionMngService = connectionMngService;
    }

    public List<ConnectionForGC> getAllConnections() {
        List connections = this.connectionService.findAll();
        List list = this.merge(connections);
        long count = this.connectionMngService.count();
        if (count != (long)list.size()) {
            List connectionMngs = this.connectionMngService.getAll();
            for (ConnectionMng connectionMng : connectionMngs) {
                list.stream().filter(c -> Objects.equals(c.getConnection().getId(), connectionMng.getConnectionId())).findAny().ifPresentOrElse(c -> {}, () -> this.connectionMngService.delete(connectionMng.getConnectionId()));
            }
        }
        return list;
    }

    public void deleteAll(List<Long> connectionIds) {
        for (Long connectionId : connectionIds) {
            this.connectionService.deleteById(connectionId);
        }
    }

    public List<ConnectionForGC> getAllConnectionsNotContains(List<Long> allConnectionIds) {
        List connections = this.connectionService.getAllConnectionsNotContains(allConnectionIds);
        if (connections.isEmpty()) {
            if (this.connectionMngService.count() != 0L) {
                this.connectionMngService.getAll().forEach(c -> {
                    if (!allConnectionIds.contains(c.getConnectionId())) {
                        this.connectionMngService.delete(c.getConnectionId());
                    }
                });
            }
            return null;
        }
        return this.merge(connections);
    }

    public boolean exists(Long id) {
        return this.connectionService.existsById(id);
    }

    public void deleteById(Long id) {
        this.connectionService.deleteById(id);
    }

    public ConnectionForGC getById(Long id) {
        Connection connection = this.connectionService.getById(id);
        ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(id);
        return new ConnectionForGC(connection, connectionMng);
    }

    private List<ConnectionForGC> merge(List<Connection> connections) {
        ArrayList<ConnectionForGC> list = new ArrayList<ConnectionForGC>();
        if (connections == null) {
            return list;
        }
        connections.forEach(c -> {
            try {
                ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(c.getId());
                list.add(new ConnectionForGC(c, connectionMng));
            }
            catch (ConnectionNotFoundException e) {
                this.connectionService.deleteOnlyConnection(c.getId());
            }
        });
        return list;
    }
}

