/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.gc.base.strategy;

import com.becon.opencelium.backend.configuration.ApplicationContextProvider;
import com.becon.opencelium.backend.gc.base.RunGCEvent;
import com.becon.opencelium.backend.gc.base.strategy.GCTriggerStrategy;
import com.becon.opencelium.backend.gc.connection.ConnectionForGC;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class PeriodicTriggerStrategy<T>
implements GCTriggerStrategy {
    private final long fixedDelay;
    private final long initialDelay;
    private static final long DEFAULT_FIXED_DELAY = 100000L;
    private static final long DEFAULT_INITIAL_DELAY = 100000L;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ThreadPoolTaskScheduler taskScheduler;

    public PeriodicTriggerStrategy(long fixedDelay, long initialDelay) {
        this.fixedDelay = fixedDelay >= 0L ? fixedDelay : 100000L;
        this.initialDelay = initialDelay >= 0L ? initialDelay : 100000L;
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.taskScheduler.setPoolSize(2);
        this.taskScheduler.initialize();
        this.taskScheduler.setThreadFactory((ThreadFactory)new CustomizableThreadFactory("GarbageCollector[Connection]-"));
        this.applicationEventPublisher = ApplicationContextProvider.getApplicationContext();
    }

    public PeriodicTriggerStrategy() {
        this(100000L, 100000L);
    }

    public void startTrigger() {
        this.taskScheduler.scheduleWithFixedDelay(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new RunGCEvent((Object)new ConnectionForGC())), Instant.now().plusMillis(this.initialDelay), Duration.ofMillis(this.fixedDelay));
    }

    public void shutdown() {
        this.taskScheduler.shutdown();
    }
}

