/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.socket;

import com.becon.opencelium.backend.execution.socket.Connection2WebSocketChannelMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class WebSocketNotificationService {
    private final SimpMessagingTemplate simpMessagingTemplate;
    private final Connection2WebSocketChannelMapping connection2ChannelMapping;

    public WebSocketNotificationService(SimpMessagingTemplate simpMessagingTemplate, Connection2WebSocketChannelMapping connection2ChannelMapping) {
        this.simpMessagingTemplate = simpMessagingTemplate;
        this.connection2ChannelMapping = connection2ChannelMapping;
    }

    public <E> void send(String destination, E message) {
        this.simpMessagingTemplate.convertAndSend((Object)destination, message);
    }

    public <E> void send(long connectionId, E message) {
        String channelId = this.connection2ChannelMapping.getChannelId(Long.valueOf(connectionId));
        if (channelId != null) {
            this.simpMessagingTemplate.convertAndSend((Object)("/execution/logs/" + channelId), message);
        }
    }
}

