/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.socket;

import com.becon.opencelium.backend.security.JwtTokenUtil;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class WebSocketHandshakeInterceptor
implements HandshakeInterceptor {
    private final JwtTokenUtil jwtTokenUtil;

    public WebSocketHandshakeInterceptor(JwtTokenUtil jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest servletRequest = (ServletServerHttpRequest)request;
            String token = servletRequest.getServletRequest().getParameter("token");
            String jwt = token.substring(7);
            int userId = this.jwtTokenUtil.extractUserId(jwt);
            String sessionId = this.jwtTokenUtil.extractSessionId(jwt);
            String principal = this.jwtTokenUtil.extractPrincipal(jwt);
            attributes.put("userId", userId);
            attributes.put("ocSessionId", sessionId);
            attributes.put("principal", principal);
            return true;
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

