/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.socket;

import com.becon.opencelium.backend.execution.socket.Event;
import com.becon.opencelium.backend.execution.socket.WebSocketEventHandler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Component;

@Component
public class WebSocketEventHandler {
    private final Map<Integer, Connection> connections = new ConcurrentHashMap();
    private final SimpMessagingTemplate messagingTemplate;
    private static final Logger logger = LoggerFactory.getLogger(WebSocketEventHandler.class);

    public WebSocketEventHandler(@Lazy SimpMessagingTemplate messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }

    public void handleConnect(StompHeaderAccessor accessor) {
        Integer userId = (Integer)accessor.getSessionAttributes().get("userId");
        String principal = (String)accessor.getSessionAttributes().get("principal");
        String wsSessionId = accessor.getSessionId();
        String ocSessionId = (String)accessor.getSessionAttributes().get("ocSessionId");
        if (userId == null || wsSessionId == null) {
            logger.error("Missing userId or wsSessionId in STOMP headers.");
            throw new IllegalArgumentException("Missing userId or wsSessionId in STOMP headers.");
        }
        if (this.connections.containsKey(userId)) {
            Connection existing = (Connection)this.connections.get(userId);
            if (Objects.equals(ocSessionId, existing.ocSessionId)) {
                existing.addSession(wsSessionId);
                logger.info("WebSocket connection has been added, userId = {}, wsSessionId = {}", (Object)userId, (Object)wsSessionId);
                return;
            }
            this.messagingTemplate.convertAndSendToUser(existing.principal, "/session", (Object)Event.of((String)"FORCE_LOGOUT", (String)"New login detected"));
            this.connections.remove(userId);
            logger.info("WebSocket connections have been unregistered, userId = {}, wsSessionIds = {}", (Object)userId, (Object)existing.wsSessionIds);
        }
        Connection connection = new Connection(this, principal, ocSessionId, wsSessionId);
        this.connections.put(userId, connection);
        logger.info("WebSocket connection has been established, userId = {}, wsSessionId = {}", (Object)userId, (Object)wsSessionId);
    }

    public void handleDisconnect(StompHeaderAccessor accessor) {
        Integer userId = (Integer)accessor.getSessionAttributes().get("userId");
        String wsSessionId = accessor.getSessionId();
        if (this.connections.containsKey(userId)) {
            if (((Connection)this.connections.get(userId)).removeSession(wsSessionId)) {
                logger.info("WebSocket connection has been unregistered, userId = {}, wsSessionId = {}", (Object)userId, (Object)wsSessionId);
            }
            if (((Connection)this.connections.get((Object)userId)).wsSessionIds.isEmpty()) {
                this.connections.remove(userId);
            }
        }
    }
}

