/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.oc721;

import com.becon.opencelium.backend.execution.ExecutionManager;
import com.becon.opencelium.backend.execution.oc721.Enhancement;
import com.becon.opencelium.backend.execution.oc721.EnhancementService;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.JSObject;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;

/*
 * Exception performing whole class analysis ignored.
 */
public class EnhancementServiceImpl
implements EnhancementService {
    private final ExecutionManager executionManager;

    public EnhancementServiceImpl(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    public Object execute(Enhancement enhancement) {
        boolean isPrimitive;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> varNameValuePairs = new HashMap<String, String>();
        enhancement.getArgs().forEach((varName, ref) -> {
            try {
                Object value = this.executionManager.getValue(ref);
                String stringValue = value instanceof String ? value.toString() : mapper.writeValueAsString(value);
                stringValue = stringValue.replace("__oc__attributes.", "@").replace(".__oc__value", "");
                varNameValuePairs.put((String)varName, stringValue);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        varNameValuePairs.forEach((varName, stringValue) -> {
            if (EnhancementServiceImpl.isJSON((String)stringValue)) {
                engine.put("dataModel", stringValue);
                JSObject obj = (JSObject)EnhancementServiceImpl.evaluate((ScriptEngine)engine, (String)"JSON.parse(dataModel)");
                engine.put((String)varName, obj);
            } else {
                engine.put((String)varName, stringValue);
            }
        });
        Object result = EnhancementServiceImpl.evaluate((ScriptEngine)engine, (String)enhancement.getScript());
        boolean bl = isPrimitive = result instanceof Number || result instanceof String || result instanceof Boolean;
        if (result == null || isPrimitive) {
            return result;
        }
        boolean isArray = ((ScriptObjectMirror)result).isArray();
        try {
            ScriptObjectMirror JSON = (ScriptObjectMirror)engine.eval("JSON");
            String stringifiedResult = JSON.callMember("stringify", new Object[]{result}).toString();
            if (isArray) {
                String arrayRegex = "\\[(.*?)\\]";
                Pattern pattern = Pattern.compile(arrayRegex, 8);
                Matcher matcher = pattern.matcher(stringifiedResult);
                if (!matcher.matches()) {
                    throw new RuntimeException("Expected an array while running enhancement.");
                }
                return (List)mapper.readValue(stringifiedResult, Object.class);
            }
            return mapper.readValue(stringifiedResult, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object evaluate(ScriptEngine engine, String code) {
        try {
            return engine.eval(code);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isJSON(String value) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
            JsonFactory factory = mapper.getFactory();
            JsonParser parser = factory.createParser(value);
            JsonNode jsonObj = (JsonNode)mapper.readTree(parser);
            if (jsonObj instanceof ObjectNode || jsonObj instanceof ArrayNode) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

