/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.service;

import com.becon.opencelium.backend.utility.LogFileUtility;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LogStorageService {
    public List<String> readBlock(String execId, long startOffset, long endOffset) {
        List<String> list;
        Path logfile = this.getLogFileByExecutionId(execId);
        RandomAccessFile raf = new RandomAccessFile(logfile.toFile(), "r");
        try {
            long length = Math.max(endOffset - startOffset, 0L);
            byte[] buffer = new byte[(int)length];
            raf.seek(startOffset);
            raf.readFully(buffer);
            String content = new String(buffer, StandardCharsets.UTF_8);
            list = List.of(content.split("\\R"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        raf.close();
        return list;
    }

    private Path getLogFileByExecutionId(String executionId) {
        Path[] logfiles = new Path[]{null, null};
        Path root = LogFileUtility.toPath((String)"./logs", (String[])new String[0]);
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (logfiles[0] != null) {
            return logfiles[0];
        }
        if (logfiles[1] != null) {
            return logfiles[1];
        }
        throw new RuntimeException("Log file not found for executionId = " + executionId);
    }
}

