/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.schema;

import com.becon.opencelium.backend.execution.logger.enums.LogDetailLevel;
import com.becon.opencelium.backend.execution.logger.enums.PhaseCategory;
import com.becon.opencelium.backend.execution.logger.enums.SegmentType;
import com.becon.opencelium.backend.execution.logger.schema.PhaseSchema;
import com.becon.opencelium.backend.execution.logger.schema.PhaseSchemaRegistry;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PhaseSchemaRegistry {
    private Map<LogDetailLevel, Map<PhaseCategory, PhaseSchema>> loadedSchemas = new HashMap();

    public PhaseSchemaRegistry() {
        ObjectMapper mapper = new ObjectMapper();
        Path schemaFile = Paths.get("src/main/resources/logger/log-schema.json", new String[0]);
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.loadedSchemas = (Map)mapper.readValue(schemaFile.toFile(), (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<PhaseCategory, PhaseSchema> getSchema(LogDetailLevel level) {
        return (Map)this.loadedSchemas.get(level);
    }

    public List<String> getSegmentPropertyList(LogDetailLevel level, PhaseCategory phaseCategory, SegmentType segmentType) {
        return ((PhaseSchema)this.getSchema(level).get(phaseCategory)).getSegments().getOrDefault(segmentType.name(), List.of());
    }

    public List<String> getPhasePropertyList(LogDetailLevel level, PhaseCategory category) {
        Map schemaByPhase = (Map)this.loadedSchemas.get(level);
        if (schemaByPhase == null) {
            return Collections.emptyList();
        }
        PhaseSchema schema = (PhaseSchema)schemaByPhase.get(category);
        if (schema == null || schema.getProperties() == null) {
            return Collections.emptyList();
        }
        return schema.getProperties();
    }

    public Set<String> getAllowedSegments(LogDetailLevel level, PhaseCategory category) {
        Map schemaByPhase = (Map)this.loadedSchemas.get(level);
        if (schemaByPhase == null) {
            return Collections.emptySet();
        }
        PhaseSchema schema = (PhaseSchema)schemaByPhase.get(category);
        if (schema == null || schema.getSegments() == null) {
            return Collections.emptySet();
        }
        return schema.getSegments().keySet();
    }
}

