/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.parser;

import com.becon.opencelium.backend.execution.logger.mapper.ParsedLogLineMapper;
import com.becon.opencelium.backend.execution.logger.parser.LogLineParser;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ParsedLogLineBuilder {
    private final LogLineParser parser;
    private final ParsedLogLineMapper mapper;

    public ParsedLogLineBuilder(LogLineParser parser, ParsedLogLineMapper mapper) {
        this.parser = parser;
        this.mapper = mapper;
    }

    public boolean supports(String line) {
        return this.parser.supports(line);
    }

    public ParsedLogLine build(String line, long startOffset, long endOffset) {
        Map parsed = this.parser.parse(line);
        return this.mapper.map(parsed, startOffset, endOffset);
    }

    public ParsedLogLine build(String line) {
        Map parsed = this.parser.parse(line);
        return this.mapper.map(parsed);
    }
}

