/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.mapper;

import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.enums.LogLineStage;
import com.becon.opencelium.backend.execution.logger.enums.LogLineType;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.enums.SegmentType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.mapper.ParsedLogLineMapper;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ParsedLogLineMapper {
    public ParsedLogLine map(Map<LogLineKey, String> parsedMap, long startOffset, long endOffset) {
        ParsedLogLine parsedLogLine = this.map(parsedMap);
        parsedLogLine.setStartOffset(startOffset);
        parsedLogLine.setEndOffset(endOffset);
        return parsedLogLine;
    }

    public ParsedLogLine map(Map<LogLineKey, String> parsedMap) {
        LogLineKey key;
        LogLineType type;
        ParsedLogLine parsedLogLine = new ParsedLogLine();
        if (parsedMap.containsKey(LogLineKey.SEGMENT)) {
            type = LogLineType.SEGMENT;
            key = LogLineKey.SEGMENT;
        } else if (parsedMap.containsKey(LogLineKey.PHASE)) {
            type = LogLineType.PHASE;
            key = LogLineKey.PHASE;
        } else {
            throw new IllegalArgumentException("Missing required key: 'segment' or 'phase'. Keys: " + String.valueOf(parsedMap.keySet()));
        }
        String rawValue = parsedMap.get(key);
        SegmentType stage = switch (1.$SwitchMap$com$becon$opencelium$backend$execution$logger$enums$LogLineType[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> SegmentType.fromString((String)rawValue);
            case 2 -> PhaseType.valueOf((String)rawValue);
        };
        parsedLogLine.setType(type);
        parsedLogLine.setStage((LogLineStage)stage);
        parsedLogLine.setRawLogLine(parsedMap.get(LogLineKey.MESSAGE));
        parsedLogLine.setProperties(parsedMap);
        return parsedLogLine;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PhaseContext toPhaseContext(ParsedLogLine line, List<String> allowedKeys) {
        Map rawProps;
        PhaseContext context;
        block7: {
            block6: {
                if (line.getType() != LogLineType.PHASE) {
                    throw new IllegalArgumentException("Expected PHASE line, got: " + String.valueOf(line.getType()));
                }
                context = new PhaseContext(line);
                rawProps = line.getProperties();
                if (allowedKeys == null) break block6;
                if (!allowedKeys.isEmpty()) break block7;
            }
            rawProps.forEach((arg_0, arg_1) -> ((PhaseContext)context).addProperty(arg_0, arg_1));
            return context;
        }
        Iterator<String> iterator = allowedKeys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (LogLineKey.from((String)key).isEmpty()) {
                throw new IllegalArgumentException(String.format("Key '%s' from log-schema.json file not found in LogLineKeys", key));
            }
            LogLineKey logKey = (LogLineKey)LogLineKey.from((String)key).get();
            if (!rawProps.containsKey(logKey)) continue;
            context.addProperty(logKey, (String)rawProps.get(logKey));
        }
        return context;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SegmentContext toSegmentContext(ParsedLogLine line, List<String> allowedKeys) {
        Map rawProps;
        SegmentContext context;
        block7: {
            block6: {
                if (line.getType() != LogLineType.SEGMENT) {
                    throw new IllegalArgumentException("Expected SEGMENT line, got: " + String.valueOf(line.getType()));
                }
                context = new SegmentContext((SegmentType)line.getStage());
                rawProps = line.getProperties();
                if (allowedKeys == null) break block6;
                if (!allowedKeys.isEmpty()) break block7;
            }
            rawProps.forEach((arg_0, arg_1) -> ((SegmentContext)context).addProperty(arg_0, arg_1));
            return context;
        }
        Iterator<String> iterator = allowedKeys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (LogLineKey.from((String)key).isEmpty()) {
                throw new IllegalArgumentException(String.format("Key '%s' from log-schema.json file not found in LogLineKeys", key));
            }
            LogLineKey logKey = (LogLineKey)LogLineKey.from((String)key).get();
            if (!rawProps.containsKey(logKey)) continue;
            context.addProperty(logKey, (String)rawProps.get(logKey));
        }
        return context;
    }
}

