/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.context;

import com.becon.opencelium.backend.execution.logger.context.PhaseContext;
import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.dto.ErrorDetail;
import com.becon.opencelium.backend.execution.logger.enums.PhaseStatus;
import com.becon.opencelium.backend.execution.logger.enums.PhaseType;
import com.becon.opencelium.backend.execution.logger.enums.SegmentType;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class PhaseContextManager {
    private String execId;
    private String connectionId;
    private String flowId;
    private String connectorName;
    private ErrorDetail exception;
    private final Deque<PhaseContext> stack = new ArrayDeque();

    public void startPhase(PhaseContext phaseContext) {
        Map props = phaseContext.getParsedLogLine().getProperties();
        props.put(LogLineKey.EXECUTION_ID, this.execId);
        props.put(LogLineKey.CONNECTION_ID, this.connectionId);
        if (this.flowId != null) {
            props.put(LogLineKey.FLOWCHART_ID, this.flowId);
            props.put(LogLineKey.CONNECTOR_NAME, this.connectorName);
        }
        this.stack.push(phaseContext);
    }

    public PhaseContext endPhase(PhaseContext phaseContext) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("No phases to end. Stack is empty.");
        }
        PhaseContext removed = null;
        while (!this.stack.isEmpty()) {
            PhaseContext current = (PhaseContext)this.stack.pop();
            String startIndex = (String)current.getParsedLogLine().getProperties().get(LogLineKey.INDEX_PATH);
            String endIndex = (String)phaseContext.getParsedLogLine().getProperties().get(LogLineKey.INDEX_PATH);
            if (phaseContext.getParsedLogLine().getStage() == PhaseType.FLOWCHART_END) {
                startIndex = (String)current.getParsedLogLine().getProperties().get(LogLineKey.FLOWCHART_ID);
                endIndex = (String)phaseContext.getParsedLogLine().getProperties().get(LogLineKey.FLOWCHART_ID);
                this.flowId = "";
            } else if (phaseContext.getParsedLogLine().getStage() == PhaseType.EXECUTION_END) {
                startIndex = (String)current.getParsedLogLine().getProperties().get(LogLineKey.EXECUTION_ID);
                endIndex = (String)phaseContext.getParsedLogLine().getProperties().get(LogLineKey.EXECUTION_ID);
                this.execId = "";
                this.connectionId = "";
            }
            if (!startIndex.equals(endIndex)) continue;
            current.setEndOffset(phaseContext.getEndOffset());
            current.setStatus(PhaseStatus.COMPLETE);
            removed = current;
            break;
        }
        if (removed == null) {
            throw new IllegalStateException("Phase context to end was not found in stack.");
        }
        removed.setErrorDetail(this.exception);
        return removed;
    }

    public PhaseContext endCurrentPhase() {
        return (PhaseContext)this.stack.pop();
    }

    public PhaseContext getCurrentPhase() {
        return (PhaseContext)this.stack.peek();
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public List<PhaseContext> handleException() {
        ArrayList<PhaseContext> closed = new ArrayList<PhaseContext>();
        while (!this.stack.isEmpty()) {
            PhaseContext ctx = (PhaseContext)this.stack.pop();
            closed.add(ctx);
        }
        return closed;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void reset() {
        this.stack.clear();
    }

    public void addExceptionSegment(String errorOfOriginPath, SegmentContext segmentContext) {
        if (segmentContext.getSegmentType() != SegmentType.EXCEPTION) {
            throw new IllegalArgumentException("Requires only EXCEPTION type. Segment type: " + segmentContext.getSegmentType().name() + " is not acceptable.");
        }
        PhaseContext currentPhase = this.getCurrentPhase();
        ErrorDetail errorDetail = new ErrorDetail(errorOfOriginPath, segmentContext);
        currentPhase.setErrorDetail(errorDetail);
        currentPhase.setStatus(PhaseStatus.FAIL);
        this.exception = errorDetail;
    }

    public ErrorDetail getException() {
        return this.exception;
    }
}

