/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.execution.logger.context;

import com.becon.opencelium.backend.execution.logger.context.SegmentContext;
import com.becon.opencelium.backend.execution.logger.dto.ErrorDetail;
import com.becon.opencelium.backend.execution.logger.enums.PhaseStatus;
import com.becon.opencelium.backend.execution.logger.keys.LogLineKey;
import com.becon.opencelium.backend.execution.logger.parser.entity.ParsedLogLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PhaseContext {
    private final ParsedLogLine parsedLogLine;
    private final long startOffset;
    private long endOffset;
    private PhaseStatus status;
    private final List<SegmentContext> segments = new ArrayList();
    private ErrorDetail errorDetail;

    public PhaseContext(ParsedLogLine parsedLogLine) {
        ParsedLogLine cloned = new ParsedLogLine(parsedLogLine.getType());
        cloned.setStartOffset(parsedLogLine.getStartOffset());
        cloned.setEndOffset(parsedLogLine.getEndOffset());
        cloned.setStage(parsedLogLine.getStage());
        cloned.setType(parsedLogLine.getType());
        cloned.setProperties(new HashMap());
        cloned.setRawLogLine(parsedLogLine.getRawLogLine());
        this.parsedLogLine = cloned;
        this.endOffset = parsedLogLine.getEndOffset();
        this.startOffset = parsedLogLine.getStartOffset();
    }

    public ParsedLogLine getParsedLogLine() {
        return this.parsedLogLine;
    }

    public PhaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public Map<LogLineKey, String> getProperties() {
        return this.parsedLogLine.getProperties();
    }

    public void addProperty(LogLineKey key, String value) {
        this.parsedLogLine.getProperties().put(key, value);
    }

    public List<SegmentContext> getSegments() {
        return this.segments;
    }

    public void addSegment(SegmentContext seg) {
        this.segments.add(seg);
    }

    public String getProperty(LogLineKey key) {
        return (String)this.parsedLogLine.getProperties().get(key);
    }

    public ErrorDetail getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(ErrorDetail errorDetail) {
        this.errorDetail = errorDetail;
    }
}

