/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.Widget;
import com.becon.opencelium.backend.database.mysql.entity.WidgetSetting;
import com.becon.opencelium.backend.database.mysql.repository.WidgetSettingRepository;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.WidgetServiceImp;
import com.becon.opencelium.backend.database.mysql.service.WidgetSettingService;
import com.becon.opencelium.backend.resource.user.WidgetSettingResource;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WidgetSettingServiceImp
implements WidgetSettingService {
    @Autowired
    private WidgetSettingRepository widgetSettingRepository;
    @Autowired
    private WidgetServiceImp widgetServiceImp;
    @Autowired
    @Lazy
    private UserServiceImpl userService;

    public void create(WidgetSetting widgetSetting) {
        this.widgetSettingRepository.save((Object)widgetSetting);
    }

    public void update(WidgetSetting widgetSetting) {
        this.widgetSettingRepository.save((Object)widgetSetting);
    }

    public WidgetSetting findByName(String name) {
        return null;
    }

    public void deleteByName(String name) {
    }

    public List<WidgetSetting> findAll() {
        return this.widgetSettingRepository.findAll();
    }

    public WidgetSetting findById(int id) {
        return (WidgetSetting)this.widgetSettingRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("WidgetNotFound"));
    }

    @Transactional
    public void deleteById(int id) {
        this.widgetSettingRepository.deleteById(id);
    }

    public void saveAll(List<WidgetSetting> widgetSettings) {
        this.widgetSettingRepository.saveAll(widgetSettings);
    }

    @Transactional
    public void deleteAll() {
        this.widgetSettingRepository.deleteAll();
    }

    public List<WidgetSetting> findAllByUserId(int id) {
        return this.widgetSettingRepository.findByUserId(id);
    }

    public WidgetSettingResource toResource(WidgetSetting widgetSetting) {
        return new WidgetSettingResource(widgetSetting);
    }

    public WidgetSetting toEntity(WidgetSettingResource widgetSettingResource, int userId) {
        Widget widget = (Widget)this.widgetServiceImp.findById(widgetSettingResource.getWidgetId()).orElseThrow(() -> new RuntimeException("Widget not found"));
        User user = (User)this.userService.findById(userId).orElseThrow(() -> new RuntimeException("Widget not found"));
        return new WidgetSetting(widgetSettingResource, widget, user);
    }

    public List<WidgetSetting> findByUserId(int id) {
        return this.widgetSettingRepository.findByUserId(id);
    }
}

