/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Component;
import com.becon.opencelium.backend.database.mysql.entity.Permission;
import com.becon.opencelium.backend.database.mysql.entity.RoleHasPermission;
import com.becon.opencelium.backend.database.mysql.entity.UserRole;
import com.becon.opencelium.backend.database.mysql.repository.UserRoleRepository;
import com.becon.opencelium.backend.database.mysql.service.ComponentServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.PermissionServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserRoleService;
import com.becon.opencelium.backend.resource.user.UserRoleResource;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRoleServiceImpl
implements UserRoleService {
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    private PermissionServiceImpl permissionService;
    @Autowired
    private ComponentServiceImpl componentService;

    public boolean existsById(int id) {
        return this.userRoleRepository.existsById((Object)id);
    }

    public Optional<UserRole> findById(int id) {
        return this.userRoleRepository.findById((Object)id);
    }

    public List<UserRole> findAll() {
        return this.userRoleRepository.findAll();
    }

    public UserRole getOne(int id) {
        return (UserRole)this.userRoleRepository.getReferenceById((Object)id);
    }

    public boolean existsByRole(String role) {
        return this.userRoleRepository.existsByName(role);
    }

    public Optional<UserRole> findByRole(String role) {
        return this.userRoleRepository.findByName(role);
    }

    public void deleteById(int id) {
        this.userRoleRepository.deleteById((Object)id);
    }

    public UserRole toEntity(UserRoleResource resource) {
        UserRole role = new UserRole();
        role.setId(resource.getGroupId());
        role.setName(resource.getName());
        role.setDescription(resource.getDescription());
        role.setIcon(resource.getIcon());
        Set components = resource.getComponents().stream().flatMap(c -> c.getPermissions().stream().map(p -> new RoleHasPermission(role, (Component)this.componentService.findById(c.getComponentId()).get(), (Permission)this.permissionService.findByName(p).get()))).collect(Collectors.toSet());
        role.setComponents(components);
        return role;
    }

    public void save(UserRole userRole) {
        this.userRoleRepository.save((Object)userRole);
    }

    public UserRoleResource toResource(UserRole entity) {
        return new UserRoleResource(entity);
    }
}

