/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.ActivationRequest;
import com.becon.opencelium.backend.database.mysql.entity.ExtraOps;
import com.becon.opencelium.backend.database.mysql.entity.OperationUsageHistory;
import com.becon.opencelium.backend.database.mysql.entity.OperationUsageHistoryDetail;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.repository.SubscriptionRepository;
import com.becon.opencelium.backend.database.mysql.service.ActivationRequestService;
import com.becon.opencelium.backend.database.mysql.service.ExtraOpsService;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryDetailService;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.enums.ActivReqStatus;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationQueue;
import com.becon.opencelium.backend.quartz.ResetLimitsJob;
import com.becon.opencelium.backend.resource.execution.ConnectionEx;
import com.becon.opencelium.backend.resource.subs.SubsDTO;
import com.becon.opencelium.backend.subscription.dto.ExtraOpsDTO;
import com.becon.opencelium.backend.subscription.dto.LicenseKey;
import com.becon.opencelium.backend.subscription.enums.ExtraOpsStatus;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import com.becon.opencelium.backend.subscription.utility.MonthPeriod;
import com.becon.opencelium.backend.utility.MachineUtility;
import com.becon.opencelium.backend.utility.crypto.HmacUtility;
import com.becon.opencelium.backend.utility.crypto.HmacValidator;
import jakarta.transaction.Transactional;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionServiceImpl
implements SubscriptionService {
    private final SubscriptionRepository subscriptionRepository;
    private final Scheduler scheduler;
    private final OperationUsageHistoryService operationUsageHistoryService;
    private final OperationUsageHistoryDetailService operationUsageHistoryDetailService;
    private final ActivationRequestService activationRequestService;
    private final ExtraOpsService extraOpsService;
    private final WebSocketNotificationQueue notificationQueue;
    private final Logger logger = LoggerFactory.getLogger(SubscriptionServiceImpl.class);

    public SubscriptionServiceImpl(SubscriptionRepository subscriptionRepository, Scheduler scheduler, @Qualifier(value="operationUsageHistoryServiceImpl") OperationUsageHistoryService operationUsageHistoryService, @Qualifier(value="operationUsageHistoryDetailServiceImp") OperationUsageHistoryDetailService operationUsageHistoryDetailService, @Qualifier(value="extraOpsServiceImp") ExtraOpsService extraOpsService, @Qualifier(value="activationRequestServiceImp") ActivationRequestService activationRequestService, WebSocketNotificationQueue notificationQueue) {
        this.subscriptionRepository = subscriptionRepository;
        this.scheduler = scheduler;
        this.operationUsageHistoryService = operationUsageHistoryService;
        this.operationUsageHistoryDetailService = operationUsageHistoryDetailService;
        this.activationRequestService = activationRequestService;
        this.extraOpsService = extraOpsService;
        this.notificationQueue = notificationQueue;
    }

    public LicenseKey decryptLicenseKey(String license) {
        return LicenseKeyUtility.decrypt((String)license);
    }

    public boolean isValid(Subscription sub) {
        if (sub == null) {
            this.logger.warn("No active subscription found. Please activate a free license or upload your license");
            return false;
        }
        LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)sub.getLicenseKey());
        boolean isValid = LicenseKeyUtility.verify((LicenseKey)licenseKey, (HmacValidator)sub.getActivationRequest());
        if (!this.isCurrentUsageIsValid(sub)) {
            this.logger.warn("Usage number of operation has been changed manually.");
            return false;
        }
        if (licenseKey.getOperationUsage() != 0L && sub.getCurrentUsage() >= licenseKey.getOperationUsage()) {
            if (!this.hasExtra(sub)) {
                this.logger.warn("You have reached limit of operation usage: {}", (Object)licenseKey.getOperationUsage());
                return false;
            }
            if (!this.hasExtraUsage(sub.getExtraOpsList())) {
                this.logger.warn("You have reached limit of Extra Ops usage: {}", (Object)licenseKey.getOperationUsage());
                return false;
            }
        }
        return isValid;
    }

    private boolean hasExtraUsage(List<ExtraOps> extraOpsList) {
        return extraOpsList.stream().filter(ops -> ops.getStatus() == ExtraOpsStatus.ACTIVE).anyMatch(ops -> ops.getCurrentOpsUsage() < ops.getTotalOpsUsage());
    }

    private boolean isHmacValid(Subscription sub, String hmac) {
        return HmacUtility.verify((String)(sub.getActivationRequest().getId() + MachineUtility.getStringForHmacEncode()), (String)hmac);
    }

    @Transactional
    public void resetMonthlyUsageForLicense(String localSubId) {
        Optional optionalLicense = this.subscriptionRepository.findById((Object)localSubId);
        if (optionalLicense.isPresent()) {
            Subscription subscription = (Subscription)optionalLicense.get();
            LocalDate currentDate = LocalDate.now();
            LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)subscription.getLicenseKey());
            LocalDate startDate = Instant.ofEpochMilli(licenseKey.getStartDate()).atZone(ZoneId.of("UTC")).toLocalDate();
            LocalDate endDate = Instant.ofEpochMilli(licenseKey.getEndDate()).atZone(ZoneId.of("UTC")).toLocalDate();
            if (currentDate.isAfter(startDate) && currentDate.isBefore(endDate)) {
                subscription.setCurrentUsage(0L);
                String newHmac = HmacUtility.encode((String)(subscription.getId() + "0"));
                subscription.setCurrentUsageHmac(newHmac);
                this.subscriptionRepository.save((Object)subscription);
            }
        }
    }

    public Subscription findByLicenseId(String licenseId) {
        return (Subscription)this.subscriptionRepository.findByLicenseId(licenseId).orElseThrow(() -> {
            this.logger.error("Subscription not found for licenseId: {}", (Object)licenseId);
            return new RuntimeException("SUBSCRIPTION_NOT_FOUND");
        });
    }

    public void save(Subscription subscription) {
        this.deactivateAll();
        subscription.setCurrentUsageHmac(HmacUtility.encode((String)(subscription.getId() + subscription.getCurrentUsage())));
        this.initUsageResetJob(subscription);
        this.subscriptionRepository.save((Object)subscription);
    }

    public void update(Subscription subscription) {
        this.subscriptionRepository.save((Object)subscription);
    }

    public Subscription setSubscription(String licenseKey, ActivationRequest newAr) {
        if (newAr.getStatus().equals((Object)ActivReqStatus.EXPIRED)) {
            throw new RuntimeException("Couldn't activate license. Activation request has been expired and license is not valid anymore. Generate new Activation Request.");
        }
        this.activationRequestService.deactivateAll();
        newAr.setStatus(ActivReqStatus.PROCESSED);
        newAr.setActive(true);
        this.activationRequestService.save(newAr);
        Subscription subscription = this.convertToSub(licenseKey, newAr);
        this.deactivateAll();
        this.save(subscription);
        return subscription;
    }

    public void deleteBySubId(String subId) {
        this.subscriptionRepository.deleteBySubId(subId);
        this.activateDefault();
    }

    public void deleteByLicenseId(String licenseId) {
        this.subscriptionRepository.deleteByLicenseId(licenseId);
        this.activateDefault();
    }

    public boolean exists(String subId) {
        return this.subscriptionRepository.existsBySubId(subId);
    }

    public Subscription convertToSub(String licenseKey, ActivationRequest ar) {
        LicenseKey lk = LicenseKeyUtility.decrypt((String)licenseKey);
        if (!LicenseKeyUtility.verify((LicenseKey)lk, (HmacValidator)ar)) {
            throw new RuntimeException("LicenseKey is not valid");
        }
        Subscription subscription = this.subscriptionRepository.findBySubId(lk.getSubId()).orElse(null);
        if (subscription == null) {
            subscription = new Subscription();
            subscription.setId(UUID.randomUUID().toString());
        }
        subscription.setSubId(lk.getSubId());
        subscription.setCreatedAt(LocalDateTime.now());
        subscription.setCurrentUsage(0L);
        subscription.setActive(true);
        subscription.setCurrentUsageHmac(HmacUtility.encode((String)(subscription.getId() + subscription.getCurrentUsage())));
        subscription.setActivationRequest(ar);
        subscription.setLicenseKey(licenseKey);
        subscription.setLicenseId(lk.getLicenseId());
        return subscription;
    }

    public void deactivateAll() {
        this.subscriptionRepository.deactivateAll();
        this.killAllTasks();
    }

    public Subscription getActiveSubs() {
        return this.subscriptionRepository.findFirstByActiveTrue().orElse(null);
    }

    public SubsDTO toDto(LicenseKey licenseKey, Subscription subscription) {
        SubsDTO subsDTO = new SubsDTO();
        subsDTO.setActive(subscription.isActive());
        subsDTO.setSubId(subscription.getSubId());
        subsDTO.setLicenseId(subscription.getLicenseId());
        subsDTO.setCurrentOperationUsage(subscription.getCurrentUsage());
        subsDTO.setDuration(licenseKey.getDuration());
        subsDTO.setType(licenseKey.getType());
        subsDTO.setStartDate(licenseKey.getStartDate());
        subsDTO.setSubId(licenseKey.getSubId());
        subsDTO.setEndDate(licenseKey.getEndDate());
        subsDTO.setTotalOperationUsage(licenseKey.getOperationUsage());
        if (subscription.getExtraOpsList() != null && !subscription.getExtraOpsList().isEmpty()) {
            List<ExtraOpsDTO> extraOpsDTOList = subscription.getExtraOpsList().stream().map(arg_0 -> ((ExtraOpsService)this.extraOpsService).toDTO(arg_0)).toList();
            subsDTO.setExtraOps(extraOpsDTOList);
        }
        MonthPeriod period = LicenseKeyUtility.getCurrentMonthPeriod((long)licenseKey.getStartDate());
        subsDTO.setMonthPeriod(period);
        return subsDTO;
    }

    public Subscription getById(String id) {
        return (Subscription)this.subscriptionRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Subscription not found: " + id));
    }

    @Transactional
    public void updateUsage(String subId, ConnectionEx connectionEx, long opsUsage, long startTime) {
        Optional subOptional = this.subscriptionRepository.findAndLockById(subId);
        if (subOptional.isEmpty()) {
            throw new RuntimeException("Subscription not found when updating usage: " + subId);
        }
        Subscription sub = (Subscription)subOptional.get();
        OperationUsageHistory operationUsageHistory = this.operationUsageHistoryService.findByConnectionTitle(connectionEx.getConnectionName()).map(history -> {
            this.operationUsageHistoryService.incrementUsageByConnectionTitle(history.getId(), opsUsage);
            OperationUsageHistoryDetail newDetail = new OperationUsageHistoryDetail();
            newDetail.setOperationUsage(opsUsage);
            newDetail.setStartDate(Instant.ofEpochMilli(startTime).atZone(ZoneId.of("UTC")).toLocalDateTime());
            newDetail.setOperationUsageHistory(history);
            this.operationUsageHistoryDetailService.save(newDetail);
            return history;
        }).orElseGet(() -> this.operationUsageHistoryService.createNewEntity(sub, connectionEx.getConnectionName(), opsUsage, startTime, connectionEx.getSource().getInvoker(), connectionEx.getTarget().getInvoker()));
        this.operationUsageHistoryService.save(operationUsageHistory);
        if (!this.isCurrentUsageIsValid(sub)) {
            throw new RuntimeException("Number of operations has been changed manually.");
        }
        long updatedOperationUsage = sub.getCurrentUsage() + opsUsage;
        LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)sub.getLicenseKey());
        long totalUsage = licenseKey.getOperationUsage();
        long remain = totalUsage - updatedOperationUsage;
        if (sub.getCurrentUsage() < totalUsage) {
            long subOpsUsage = remain <= 0L ? totalUsage : updatedOperationUsage;
            String newHmac = HmacUtility.encode((String)(sub.getId() + subOpsUsage));
            sub.setCurrentUsage(subOpsUsage);
            sub.setCurrentUsageHmac(newHmac);
            this.update(sub);
        }
        if (remain <= 0L) {
            remain = Math.abs(remain);
            this.extraOpsService.updateExtraOpsForSubscription(sub, remain);
        }
        this.sendNotification();
    }

    public void createFreeLicenseFileIfNotExists() {
        block13: {
            String freeLicensePath = "src/main/resources/license/init-license.txt";
            File file = new File(freeLicensePath);
            File parentDirectory = file.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists()) {
                if (parentDirectory.mkdirs()) {
                    this.logger.info("Directories created: " + parentDirectory.getAbsolutePath());
                } else {
                    throw new RuntimeException("Failed to create directories: " + parentDirectory.getAbsolutePath());
                }
            }
            if (file.exists()) {
                this.logger.info("Free license already exists.");
                return;
            }
            try {
                if (file.createNewFile()) {
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write("TYidZve2brv337lPLRaQ7cUM6Xm2ecPTeodbmBjlBURwxhhWwcziT6kiTJgHCpfN6SRfXx+CdK4rhvaSh3BBFqhEhoRhdSWS5BCjMLKZQ2oQVS/kzckvF7igA3kEGjZDmdYBmvv+pFXZk7RZurBS3qUix2arH2nlmYavPqiWPV4UBKPsemMUJilCZ51j3l36UBPq7aX96wQKz5EeKOFQCg8GsNnVMjI4Tk6CYelesrBrlm1B3uULiuSnzxAvrLqi9cgmkIrIbqTagCnM9dgHCRNec7EinvHFSC4ckaLEs9N/XczYF8mBgvIFSXc298oCk6vodU5aKpLT+hJPZb3FlJ94lxHecxwH2b7RaFPNP6d6/RPWbnTJOkSwMO0JurHq5zygqT1tc3R9+7pucRaCCtmYhaGtRYuieH0dBNYGQQuwnpBlq3f8yrVHL0X6aMVvdXHf3kspWvbw/r+zffqbLOYcKWRqz2Zsiz0YMBLaujzTVIBRQiLDOHNqgOR05zJ4qx0U7v6vub4hLdOdqtHAc0WvxSbehrqa8fRa9GYlBG7f8McfgfOgMj+IJAWIuV8Nb6PAJYeElBaXA2MLjusIid5ZbX096nBuNX1hyoG8+Q5i6NWsOwHD7eurfMwU4WwZfTYfu0S+3dOcg9CCoj5lcen1NbCj5dpopjEIFhI9pZo=");
                        this.logger.info("Content written to file.");
                    }
                    this.logger.info("Free License has been created:" + freeLicensePath);
                    break block13;
                }
                this.logger.error("Free license could not be created.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isCurrentUsageIsValid(Subscription sub) {
        return HmacUtility.verify((String)(sub.getId() + sub.getCurrentUsage()), (String)sub.getCurrentUsageHmac());
    }

    private void initUsageResetJob(Subscription subscription) {
        String jobKey = "LicenseUsageResetJob-" + subscription.getId();
        String groupKey = "LicenseJobs";
        String triggerName = "LicenseTrigger-" + subscription.getId();
        String triggerGroup = "LicenseTriggers";
        JobKey jobIdentity = new JobKey(jobKey, groupKey);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroup);
        LicenseKey lk = LicenseKeyUtility.decrypt((String)subscription.getLicenseKey());
        String cron = this.generateCronExpression(lk.getStartDate());
        try {
            if (this.scheduler.checkExists(jobIdentity)) {
                Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(Date.from(Instant.ofEpochMilli(lk.getStartDate()))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).endAt(Date.from(Instant.ofEpochMilli(lk.getEndDate()))).build();
                this.scheduler.rescheduleJob(triggerKey, newTrigger);
            } else {
                JobDetail job = JobBuilder.newJob(ResetLimitsJob.class).withIdentity(jobKey, groupKey).usingJobData("localSubId", subscription.getId()).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroup).startAt(Date.from(Instant.ofEpochMilli(lk.getStartDate()))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).endAt(Date.from(Instant.ofEpochMilli(lk.getEndDate()))).build();
                this.scheduler.scheduleJob(job, trigger);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void killAllTasks() {
        try {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"LicenseJobs"));
            for (JobKey jobKey : jobKeys) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    private void activateDefault() {
        if (this.getActiveSubs() != null) {
            return;
        }
        String freeLicense = LicenseKeyUtility.readFreeLicense();
        LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)freeLicense);
        Subscription subscription = this.subscriptionRepository.findBySubId(licenseKey.getSubId()).orElseGet(() -> {
            ActivationRequest ar = (ActivationRequest)this.activationRequestService.readFreeAR().orElseThrow(() -> new RuntimeException("Free Activation Request not found!"));
            return this.convertToSub(freeLicense, ar);
        });
        subscription.setActive(true);
        this.subscriptionRepository.save((Object)subscription);
    }

    private String generateCronExpression(long startDateMillis) {
        int currentMonthMaxDays;
        LocalDateTime startDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(startDateMillis), ZoneId.of("UTC"));
        int dayOfMonth = startDate.getDayOfMonth();
        if (dayOfMonth > (currentMonthMaxDays = YearMonth.now().lengthOfMonth())) {
            this.logger.warn("Adjusting dayOfMonth {} to the last day of the current month ({} days).", (Object)dayOfMonth, (Object)currentMonthMaxDays);
            dayOfMonth = currentMonthMaxDays;
        }
        return String.format("0 0 0 %d * ?", dayOfMonth);
    }

    private boolean hasExtra(Subscription sub) {
        return sub.getExtraOpsList() != null && !sub.getExtraOpsList().isEmpty();
    }

    protected void sendNotification() {
        Subscription subscription = this.getActiveSubs();
        if (subscription != null) {
            String licenseKeyRaw = subscription.getLicenseKey();
            LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)licenseKeyRaw);
            SubsDTO subsDTO = this.toDto(licenseKey, subscription);
            this.notificationQueue.addMessage("/subscription", (Object)subsDTO);
        }
    }
}

