/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.repository.SessionRepository;
import com.becon.opencelium.backend.database.mysql.service.SessionService;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SessionServiceImpl
implements SessionService {
    @Autowired
    private SessionRepository sessionRepository;

    public Optional<Session> findById(String id) {
        return this.sessionRepository.findById((Object)id);
    }

    public void save(Session session) {
        this.sessionRepository.save((Object)session);
    }

    public Optional<Session> findByUserId(int userId) {
        return this.sessionRepository.findByUserId(userId);
    }

    @Transactional
    public void deleteByUserId(int userId) {
        this.sessionRepository.deleteByUserId(userId);
    }

    @Transactional
    public synchronized Session replace(int userId) {
        this.sessionRepository.deleteByUserId(userId);
        String sessionId = UUID.randomUUID().toString();
        Session session = new Session();
        session.setId(sessionId);
        session.setUserId(userId);
        session.setActive(true);
        session.setAttempts(0);
        return (Session)this.sessionRepository.save((Object)session);
    }

    @Transactional
    public synchronized void updateLastAccessedTime(String sessionId) {
        this.sessionRepository.updateLastAccessed(sessionId, new Date());
    }
}

