/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.EventMessage;
import com.becon.opencelium.backend.database.mysql.entity.EventNotification;
import com.becon.opencelium.backend.database.mysql.entity.EventRecipient;
import com.becon.opencelium.backend.database.mysql.entity.MaskingRule;
import com.becon.opencelium.backend.database.mysql.repository.NotificationRepository;
import com.becon.opencelium.backend.database.mysql.repository.SchedulerRepository;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.ExecutionServiceImp;
import com.becon.opencelium.backend.database.mysql.service.LastExecutionService;
import com.becon.opencelium.backend.database.mysql.service.MessageService;
import com.becon.opencelium.backend.database.mysql.service.RecipientService;
import com.becon.opencelium.backend.database.mysql.service.SchedulerService;
import com.becon.opencelium.backend.database.mysql.service.WebhookService;
import com.becon.opencelium.backend.exception.ConcurrentTestIsForbidden;
import com.becon.opencelium.backend.exception.SchedulerNotFoundException;
import com.becon.opencelium.backend.factory.SchedulerFactory;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.quartz.SchedulingStrategy;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.notification.NotificationResource;
import com.becon.opencelium.backend.resource.request.SchedulerRequestResource;
import com.becon.opencelium.backend.resource.schedule.RunningJobsResource;
import com.becon.opencelium.backend.resource.schedule.SchedulerResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerServiceImp
implements SchedulerService {
    private final ConnectionService connectionService;
    private final WebhookService webhookService;
    private final ConnectorService connectorService;
    private final LastExecutionService lastExecutionService;
    private final RecipientService recipientService;
    private final MessageService messageService;
    private final SchedulingStrategy schedulingStrategy;
    private final SchedulerRepository schedulerRepository;
    private final NotificationRepository notificationRepository;
    private final ExecutionServiceImp executionServiceImp;
    private final Mapper<Connection, ConnectionDTO> connectionMapper;

    public SchedulerServiceImp(@Lazy @Qualifier(value="connectionServiceImp") ConnectionService connectionService, @Qualifier(value="webhookServiceImp") WebhookService webhookService, @Qualifier(value="lastExecutionServiceImp") LastExecutionService lastExecutionService, @Qualifier(value="messageServiceImpl") MessageService messageService, @Qualifier(value="recipientServiceImpl") RecipientService recipientService, @Qualifier(value="connectorServiceImp") ConnectorService connectorService, SchedulerRepository schedulerRepository, NotificationRepository notificationRepository, SchedulerFactoryBean schedulerFactoryBean, ExecutionServiceImp executionServiceImp, Mapper<Connection, ConnectionDTO> connectionMapper) {
        this.connectionService = connectionService;
        this.webhookService = webhookService;
        this.lastExecutionService = lastExecutionService;
        this.recipientService = recipientService;
        this.messageService = messageService;
        this.schedulingStrategy = SchedulerFactory.createQuartzScheduler((Scheduler)schedulerFactoryBean.getScheduler());
        this.notificationRepository = notificationRepository;
        this.schedulerRepository = schedulerRepository;
        this.executionServiceImp = executionServiceImp;
        this.connectionMapper = connectionMapper;
        this.connectorService = connectorService;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void save(@NonNull com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        if (this.existsByTitle(scheduler.getTitle())) {
            throw new RuntimeException("TITLE_ALREADY_EXISTS");
        }
        com.becon.opencelium.backend.database.mysql.entity.Scheduler saved = (com.becon.opencelium.backend.database.mysql.entity.Scheduler)this.schedulerRepository.save((Object)scheduler);
        this.schedulingStrategy.addJob(saved);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public com.becon.opencelium.backend.database.mysql.entity.Scheduler update(@NonNull com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        com.becon.opencelium.backend.database.mysql.entity.Scheduler entity = this.getById(scheduler.getId());
        Long oldCon = entity.getConnection().getId();
        if (!Objects.equals(entity.getTitle(), scheduler.getTitle()) && this.existsByTitle(scheduler.getTitle())) {
            throw new RuntimeException("TITLE_ALREADY_EXISTS");
        }
        this.schedulerRepository.save((Object)scheduler);
        this.schedulingStrategy.rescheduleJob(scheduler, oldCon);
        return scheduler;
    }

    public List<com.becon.opencelium.backend.database.mysql.entity.Scheduler> saveAll(List<com.becon.opencelium.backend.database.mysql.entity.Scheduler> schedulers) {
        return this.schedulerRepository.saveAll(schedulers);
    }

    public void deleteById(int id) {
        com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler = this.getById(id);
        this.schedulingStrategy.deleteJob(scheduler);
        this.schedulerRepository.delete((Object)scheduler);
    }

    public void deleteAllById(List<Integer> schedulerIds) {
        for (Integer id : schedulerIds) {
            try {
                this.deleteById(id.intValue());
            }
            catch (Exception exception) {}
        }
    }

    public List<com.becon.opencelium.backend.database.mysql.entity.Scheduler> findAll() {
        return this.schedulerRepository.findAll();
    }

    public List<com.becon.opencelium.backend.database.mysql.entity.Scheduler> findAllByTitleContains(String title) {
        return this.schedulerRepository.findAllByTitleContains(title);
    }

    public Optional<com.becon.opencelium.backend.database.mysql.entity.Scheduler> findById(int id) {
        return this.schedulerRepository.findById((Object)id);
    }

    public com.becon.opencelium.backend.database.mysql.entity.Scheduler getById(int id) {
        return (com.becon.opencelium.backend.database.mysql.entity.Scheduler)this.schedulerRepository.findById((Object)id).orElseThrow(() -> new SchedulerNotFoundException(id));
    }

    public List<com.becon.opencelium.backend.database.mysql.entity.Scheduler> findAllById(ArrayList<Integer> ids) {
        return this.schedulerRepository.findAllById(ids);
    }

    public boolean existsByTitle(String title) {
        return this.schedulerRepository.existsByTitle(title);
    }

    public boolean existsById(int id) {
        return this.schedulerRepository.existsById((Object)id);
    }

    public com.becon.opencelium.backend.database.mysql.entity.Scheduler toEntity(SchedulerRequestResource resource) {
        Connection connection = this.connectionService.getById(resource.getConnectionId());
        com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler = new com.becon.opencelium.backend.database.mysql.entity.Scheduler();
        scheduler.setId(resource.getSchedulerId());
        scheduler.setTitle(resource.getTitle());
        scheduler.setStatus(resource.isStatus());
        scheduler.setCronExp(resource.getCronExp());
        scheduler.setConnection(connection);
        scheduler.setDebugMode(resource.isDebugMode());
        List notificationResources = resource.getNotificationResources();
        ArrayList<EventNotification> eventNotificationList = new ArrayList<EventNotification>();
        for (NotificationResource notificationResource : notificationResources) {
            eventNotificationList.add(this.toNotificationEntity(notificationResource));
        }
        scheduler.setEventNotifications(eventNotificationList);
        return scheduler;
    }

    public SchedulerResource toResource(com.becon.opencelium.backend.database.mysql.entity.Scheduler entity) {
        SchedulerResource schedulerResource = new SchedulerResource();
        schedulerResource.setSchedulerId(entity.getId());
        schedulerResource.setTitle(entity.getTitle());
        schedulerResource.setStatus(entity.getStatus());
        schedulerResource.setCronExp(entity.getCronExp());
        schedulerResource.setDebugMode(entity.getDebugMode());
        schedulerResource.setConnection((ConnectionDTO)this.connectionMapper.toDTO((Object)entity.getConnection()));
        if (entity.getLastExecution() != null) {
            schedulerResource.setLastExecution(this.lastExecutionService.toResource(entity.getLastExecution()));
        }
        if (entity.getWebhook() != null) {
            schedulerResource.setWebhook(this.webhookService.toResource(entity.getWebhook()));
        }
        List eventNotificationList = entity.getEventNotifications();
        ArrayList<NotificationResource> notificationResources = new ArrayList<NotificationResource>();
        for (EventNotification eventNotification : eventNotificationList) {
            notificationResources.add(new NotificationResource(eventNotification));
        }
        schedulerResource.setNotification(notificationResources);
        return schedulerResource;
    }

    public synchronized void startNow(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        this.throwIfConnectionIsBeingExecuted(scheduler.getConnection().getId().longValue());
        this.schedulingStrategy.runJob(scheduler);
    }

    public void startNow(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, String channelId) {
        this.schedulingStrategy.runJob(scheduler, channelId);
    }

    public void startNow(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, Map<String, Object> webhook) {
        this.throwIfConnectionIsBeingExecuted(scheduler.getConnection().getId().longValue());
        this.schedulingStrategy.runJob(scheduler, webhook);
    }

    public void startNow(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler, List<MaskingRule> rules) {
        this.schedulingStrategy.runJob(scheduler, rules);
    }

    public void throwIfConnectionIsBeingExecuted(long connectionId) {
        if (this.schedulingStrategy.getRunningJobs().containsKey(connectionId)) {
            throw new ConcurrentTestIsForbidden(Long.valueOf(connectionId));
        }
    }

    public void saveEntity(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        this.schedulerRepository.save((Object)scheduler);
    }

    public void disable(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        this.schedulingStrategy.pauseJob(scheduler);
    }

    public void enable(com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler) {
        this.schedulingStrategy.resumeJob(scheduler);
    }

    public void terminate(Integer schedulerId) {
        com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler = this.getById(schedulerId.intValue());
        this.schedulingStrategy.terminate(scheduler);
    }

    public List<RunningJobsResource> getAllRunningJobs() {
        Map runningJobs = this.schedulingStrategy.getRunningJobs();
        ArrayList<RunningJobsResource> runningJobsResources = new ArrayList<RunningJobsResource>();
        runningJobs.forEach((connId, schedId) -> {
            RunningJobsResource jobsResource = new RunningJobsResource();
            com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler = this.getById(schedId.intValue());
            jobsResource.setSchedulerId(scheduler.getId());
            jobsResource.setTitle(scheduler.getTitle());
            double avg = this.executionServiceImp.getAvgDurationOfExecution(schedId.intValue());
            jobsResource.setAvgDuration(avg);
            Connection connection = this.connectionService.getById(connId);
            Connector fromCotr = this.connectorService.getById(Integer.valueOf(connection.getFromConnector()));
            Connector toCtor = this.connectorService.getById(Integer.valueOf(connection.getToConnector()));
            jobsResource.setToConnector(toCtor.getTitle());
            jobsResource.setFromConnector(fromCotr.getTitle());
            runningJobsResources.add(jobsResource);
        });
        return runningJobsResources;
    }

    public List<RunningJobsResource> getAllRunningJobsExcludingOne(int schedulerId) {
        Map runningJobs = this.schedulingStrategy.getRunningJobs();
        ArrayList<RunningJobsResource> runningJobsResources = new ArrayList<RunningJobsResource>();
        runningJobs.forEach((connId, schedId) -> {
            if (schedulerId != schedId) {
                RunningJobsResource jobsResource = new RunningJobsResource();
                com.becon.opencelium.backend.database.mysql.entity.Scheduler scheduler = this.getById(schedId.intValue());
                jobsResource.setSchedulerId(scheduler.getId());
                jobsResource.setTitle(scheduler.getTitle());
                double avg = this.executionServiceImp.getAvgDurationOfExecution(schedId.intValue());
                jobsResource.setAvgDuration(avg);
                Connection connection = this.connectionService.getById(connId);
                Connector fromCotr = this.connectorService.getById(Integer.valueOf(connection.getFromConnector()));
                Connector toCtor = this.connectorService.getById(Integer.valueOf(connection.getToConnector()));
                jobsResource.setToConnector(toCtor.getTitle());
                jobsResource.setFromConnector(fromCotr.getTitle());
                runningJobsResources.add(jobsResource);
            }
        });
        return runningJobsResources;
    }

    public List<EventNotification> getAllNotifications(int schedulerId) {
        return this.notificationRepository.findBySchedulerId(schedulerId);
    }

    public Optional<EventNotification> getNotification(int notificationId) {
        return this.notificationRepository.findById((Object)notificationId);
    }

    public EventNotification toNotificationEntity(NotificationResource resource) {
        EventNotification eventNotification = new EventNotification();
        eventNotification.setId(resource.getNotificationId());
        eventNotification.setName(resource.getName());
        eventNotification.setEventType(resource.getEventType());
        eventNotification.setScheduler((com.becon.opencelium.backend.database.mysql.entity.Scheduler)this.schedulerRepository.findById((Object)resource.getSchedulerId()).orElseThrow(() -> new RuntimeException("Scheduler " + resource.getSchedulerId() + " not found")));
        Set notificationEventRecipients = resource.getRecipients().stream().map(EventRecipient::new).collect(Collectors.toSet());
        eventNotification.setEventRecipients(notificationEventRecipients);
        eventNotification.setEventMessage((EventMessage)this.messageService.findById(resource.getTemplate().getTemplateId()).orElseThrow(() -> new RuntimeException("TEMPLATE_NOT_FOUND")));
        return eventNotification;
    }

    public NotificationResource toNotificationResource(EventNotification eventNotification) {
        return new NotificationResource(eventNotification);
    }

    public void saveNotification(EventNotification eventNotification) {
        this.notificationRepository.save((Object)eventNotification);
        eventNotification.getEventRecipients().forEach(arg_0 -> ((RecipientService)this.recipientService).save(arg_0));
        this.messageService.save(eventNotification.getEventMessage());
    }

    public void deleteNotificationById(int id) {
        this.notificationRepository.deleteById((Object)id);
    }
}

