/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.OperationUsageHistory;
import com.becon.opencelium.backend.database.mysql.entity.OperationUsageHistoryDetail;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.repository.OperationUsageHistoryRepository;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryDetailServiceImp;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryService;
import com.becon.opencelium.backend.resource.subs.OperationUsageDetailsDto;
import com.becon.opencelium.backend.resource.subs.OperationUsageHistoryDto;
import com.becon.opencelium.backend.resource.subs.PaginatedDto;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class OperationUsageHistoryServiceImpl
implements OperationUsageHistoryService {
    @Autowired
    private OperationUsageHistoryRepository operationUsageHistoryRepository;
    @Autowired
    private OperationUsageHistoryDetailServiceImp operationUsageHistoryDetailServiceImp;

    public void save(OperationUsageHistory operationUsageHistory) {
        this.operationUsageHistoryRepository.save((Object)operationUsageHistory);
    }

    public List<OperationUsageHistory> findAll() {
        return this.operationUsageHistoryRepository.findAll();
    }

    public Pageable createPageable(int page, int size, String[] sorts) {
        Sort.Direction direction = Sort.Direction.fromString((String)sorts[1]);
        Sort sortBy = Sort.by((Sort.Direction)direction, (String[])new String[]{sorts[0]});
        return PageRequest.of((int)page, (int)size, (Sort)sortBy);
    }

    public Page<OperationUsageHistoryDetail> getAllUsageDetailsByUsageId(Long usageId, Pageable pageable, LocalDateTime startDate, LocalDateTime endDate) {
        if (startDate != null || endDate != null) {
            return this.operationUsageHistoryDetailServiceImp.findDetailsByHistoryIdAndStartDateBetween(usageId, startDate, endDate, pageable);
        }
        return this.operationUsageHistoryDetailServiceImp.getAllUsageDetailsByOperationUsageHistoryId(usageId, pageable);
    }

    public Optional<OperationUsageHistory> findById(Long id) {
        return this.operationUsageHistoryRepository.findById((Object)id);
    }

    public OperationUsageHistory createNewEntity(Subscription sub, String connectionName, long operationUsage, long startTime, String sourceInvoker, String targetInvoker) {
        OperationUsageHistory operationUsageHistory = new OperationUsageHistory();
        operationUsageHistory.setSubId(sub.getId());
        operationUsageHistory.setLicenseId(sub.getLicenseId());
        operationUsageHistory.setTotalUsage(operationUsage);
        operationUsageHistory.setConnectionTitle(connectionName);
        operationUsageHistory.setCreatedAt(LocalDateTime.now());
        operationUsageHistory.setFromInvoker(sourceInvoker);
        operationUsageHistory.setToInvoker(targetInvoker);
        OperationUsageHistoryDetail operationUsageHistoryDetail = new OperationUsageHistoryDetail();
        operationUsageHistoryDetail.setOperationUsage(operationUsage);
        operationUsageHistoryDetail.setStartDate(Instant.ofEpochMilli(startTime).atZone(ZoneId.of("UTC")).toLocalDateTime());
        operationUsageHistoryDetail.setOperationUsageHistory(operationUsageHistory);
        ArrayList<OperationUsageHistoryDetail> details = new ArrayList<OperationUsageHistoryDetail>();
        details.add(operationUsageHistoryDetail);
        operationUsageHistory.setDetails(details);
        return operationUsageHistory;
    }

    public Optional<OperationUsageHistory> findByConnectionTitle(String title) {
        return this.operationUsageHistoryRepository.findByConnectionTitle(title);
    }

    public PaginatedDto<OperationUsageHistory, OperationUsageHistoryDto> toPaginatedDto(Page<OperationUsageHistory> page) {
        return new PaginatedDto(page, OperationUsageHistoryDto::new);
    }

    public PaginatedDto<OperationUsageHistoryDetail, OperationUsageDetailsDto> toUsageDetailsDto(Page<OperationUsageHistoryDetail> page) {
        return new PaginatedDto(page, OperationUsageDetailsDto::new);
    }

    public Page<OperationUsageHistory> findAllByDetailsStartDateBetween(Pageable pageable, Long startDate, Long endDate) {
        LocalDateTime start = startDate != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate), ZoneId.of("UTC")) : null;
        LocalDateTime end = endDate != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate), ZoneId.of("UTC")) : null;
        Page usageHistories = this.operationUsageHistoryRepository.findAllByTotalUsageGreaterThan(pageable, start, end);
        usageHistories.forEach(history -> {
            if (history.getDetails() != null) {
                List filteredDetails = this.operationUsageHistoryDetailServiceImp.findDetailsByHistoryIdAndStartDateBetween(history.getId(), start, end);
                long sumUsage = filteredDetails.stream().mapToLong(OperationUsageHistoryDetail::getOperationUsage).sum();
                history.setTotalUsage(sumUsage);
            }
        });
        return usageHistories;
    }

    public void incrementUsageByConnectionTitle(Long id, long opsUsage) {
        this.operationUsageHistoryRepository.incrementUsageByConnectionTitle(id, opsUsage);
    }
}

