/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.constant.props.OnlineServicesProps;
import com.becon.opencelium.backend.database.mysql.entity.OnlineSyncHistory;
import com.becon.opencelium.backend.database.mysql.repository.OnlineSyncHistoryRepository;
import com.becon.opencelium.backend.database.mysql.service.OnlineSyncHistoryService;
import com.becon.opencelium.backend.resource.onlinesync.OnlineSyncHistoryDTO;
import com.becon.opencelium.backend.resource.onlinesync.OnlineSyncStatusDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OnlineSyncHistoryServiceImpl
implements OnlineSyncHistoryService {
    private final OnlineSyncHistoryRepository repository;
    private final OnlineServicesProps onlineServicesProps;
    private static final String DEFAULT_USERNAME = "OC Autosync";

    public OnlineSyncHistoryServiceImpl(OnlineSyncHistoryRepository repository, OnlineServicesProps onlineServicesProps) {
        this.repository = repository;
        this.onlineServicesProps = onlineServicesProps;
    }

    public List<OnlineSyncHistoryDTO> findAll(String user, String service, LocalDateTime startTime, LocalDateTime endTime) {
        return this.repository.filterHistory(user, service, startTime, endTime).stream().map(history -> {
            OnlineSyncHistoryDTO dto = new OnlineSyncHistoryDTO();
            dto.setUser(history.getUsername());
            dto.setService(history.getService());
            dto.setDetails(history.getDetails());
            dto.setTimestamp(history.getCreatedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            return dto;
        }).toList();
    }

    public void save(String username, String service, List<String> details) {
        OnlineSyncHistory entity = new OnlineSyncHistory();
        entity.setUsername(username);
        entity.setService(service);
        entity.setDetails(String.join((CharSequence)", ", details));
        this.repository.save((Object)entity);
    }

    public void save(String service, List<String> details) {
        this.save(DEFAULT_USERNAME, service, details);
    }

    public OnlineSyncStatusDTO getStatus() {
        return OnlineSyncStatusDTO.fromStatus((Boolean)this.onlineServicesProps.getActive(), (Boolean)(this.onlineServicesProps.getInvokerSync() != null ? this.onlineServicesProps.getInvokerSync().getActive() : false), (Boolean)(this.onlineServicesProps.getTemplateSync() != null ? this.onlineServicesProps.getTemplateSync().getActive() : false));
    }
}

