/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Category;
import com.becon.opencelium.backend.database.mysql.repository.CategoryRepository;
import com.becon.opencelium.backend.database.mysql.service.CategoryService;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.resource.CategoryDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryServiceImp
implements CategoryService {
    private static final Logger log = LoggerFactory.getLogger(CategoryServiceImp.class);
    private final CategoryRepository repository;
    private final ConnectionService connectionService;

    public CategoryServiceImp(CategoryRepository repository, @Lazy @Qualifier(value="connectionServiceImp") ConnectionService connectionService) {
        this.repository = repository;
        this.connectionService = connectionService;
    }

    @Transactional
    public Integer add(CategoryDTO categoryDTO) {
        if (categoryDTO == null) {
            throw new RuntimeException("CATEGORY_IS_NULL");
        }
        this.checkName(categoryDTO.getName());
        Category curr = new Category();
        curr.setName(categoryDTO.getName());
        if (categoryDTO.getParentCategory() != null) {
            if (!this.repository.existsById((Object)categoryDTO.getParentCategory())) {
                throw new RuntimeException("PARENT_CATEGORY_NOT_FOUND");
            }
            curr.setParentCategory(this.get(categoryDTO.getParentCategory()));
        }
        Category saved = (Category)this.repository.save((Object)curr);
        if (categoryDTO.getSubCategories() != null) {
            categoryDTO.getSubCategories().forEach(id -> {
                if (!this.repository.existsById(id)) {
                    throw new RuntimeException("SUB_CATEGORY_NOT_FOUND(" + id + ")");
                }
                Category child = this.get(id);
                child.setParentCategory(saved);
                this.repository.save((Object)child);
            });
        }
        this.checkCycle(saved);
        return saved.getId();
    }

    @Transactional
    public void update(CategoryDTO categoryDTO) {
        if (categoryDTO == null) {
            throw new RuntimeException("CATEGORY_IS_NULL");
        }
        if (categoryDTO.getId() == null || !this.repository.existsById((Object)categoryDTO.getId())) {
            throw new RuntimeException("CATEGORY_NOT_FOUND");
        }
        Category old = this.get(categoryDTO.getId());
        if (!Objects.equals(categoryDTO.getName(), old.getName())) {
            this.checkName(categoryDTO.getName());
        }
        Category category = new Category(categoryDTO.getId());
        category.setName(categoryDTO.getName());
        category.setParentCategory(old.getParentCategory());
        if (categoryDTO.getParentCategory() != null) {
            if (old.getParentCategory() == null || !categoryDTO.getParentCategory().equals(old.getParentCategory().getId())) {
                if (!this.repository.existsById((Object)categoryDTO.getId())) {
                    throw new RuntimeException("PARENT_CATEGORY_NOT_FOUND");
                }
                category.setParentCategory(new Category(categoryDTO.getParentCategory()));
            }
        } else {
            category.setParentCategory(null);
        }
        if (categoryDTO.getSubCategories() != null && old.getSubCategories() != null) {
            categoryDTO.getSubCategories().forEach(id -> {
                if (!this.repository.existsById(id)) {
                    throw new RuntimeException("SUB_CATEGORY_NOT_FOUND(" + id + ")");
                }
                if (old.getSubCategories().stream().noneMatch(s -> s.getId().equals(id))) {
                    Category child = this.get(id);
                    child.setParentCategory(old);
                    this.repository.save((Object)child);
                }
            });
            old.getSubCategories().forEach(c -> {
                if (categoryDTO.getSubCategories().stream().noneMatch(s -> s.equals(c.getId()))) {
                    c.setParentCategory(null);
                    this.repository.save(c);
                }
            });
        } else if (old.getSubCategories() != null) {
            old.getSubCategories().forEach(c -> {
                c.setParentCategory(null);
                this.repository.save(c);
            });
        }
        Category saved = (Category)this.repository.save((Object)category);
        this.checkCycle(saved);
    }

    public Category get(Integer id) {
        return (Category)this.repository.findById((Object)id).orElseThrow(() -> new RuntimeException("CATEGORY_NOT_FOUND"));
    }

    public List<Category> getAll() {
        return this.repository.findAll();
    }

    public List<Category> getAllByIds(Iterable<Integer> ids) {
        return this.repository.findAllById(ids);
    }

    @Transactional
    public void deleteOnly(Integer id) {
        Category category = this.get(id);
        List connections = this.connectionService.getAllByCategoryId(category.getId());
        connections.forEach(c -> this.connectionService.updateCategory(c, null));
        Set subCategories = category.getSubCategories();
        if (subCategories != null) {
            subCategories.forEach(c -> {
                c.setParentCategory(null);
                this.repository.save(c);
            });
        }
        this.repository.deleteById((Object)category.getId());
    }

    @Transactional
    public void deleteAllOnly(List<Integer> ids) {
        if (ids == null) {
            return;
        }
        ids.forEach(c -> {
            if (!this.exists(c)) {
                throw new RuntimeException("CATEGORY_NOT_FOUND");
            }
        });
        for (Integer id : ids) {
            try {
                this.deleteOnly(id);
            }
            catch (Exception e) {
                log.warn("Can't delete Category[id={}] or it has been already deleted", (Object)id);
            }
        }
    }

    @Transactional
    public void cascadeDelete(Integer id) {
        Category category = this.get(id);
        List connections = this.connectionService.getAllByCategoryId(category.getId());
        this.connectionService.deleteAll(connections);
        if (category.getSubCategories() != null) {
            category.getSubCategories().forEach(c -> this.cascadeDelete(c.getId()));
        }
        this.repository.deleteById((Object)category.getId());
    }

    @Transactional
    public void cascadeDeleteAll(List<Integer> ids) {
        if (ids == null) {
            return;
        }
        ids.forEach(c -> {
            if (!this.exists(c)) {
                throw new RuntimeException("CATEGORY_NOT_FOUND(" + c + ")");
            }
        });
        for (Integer id : ids) {
            Category category;
            try {
                category = this.get(id);
            }
            catch (RuntimeException e) {
                log.warn("Can't delete Category[id={}] or it has been already deleted", (Object)id);
                continue;
            }
            this.cascadeDelete(category);
        }
    }

    public boolean exists(Integer id) {
        return this.repository.existsById((Object)id);
    }

    public boolean existsByName(String name) {
        return this.repository.existsByNameEqualsIgnoreCase(name);
    }

    @Transactional
    protected void cascadeDelete(Category category) {
        List connections = this.connectionService.getAllByCategoryId(category.getId());
        this.connectionService.deleteAll(connections);
        if (category.getSubCategories() != null) {
            for (Category sub : category.getSubCategories()) {
                if (!this.exists(sub.getId())) continue;
                this.cascadeDelete(sub);
            }
        }
        this.repository.deleteById((Object)category.getId());
    }

    private void checkName(String name) {
        if (name == null || name.isBlank()) {
            throw new RuntimeException("INVALID_CATEGORY_NAME");
        }
        if (this.repository.existsByNameEqualsIgnoreCase(name)) {
            throw new RuntimeException("TITLE_HAS_ALREADY_TAKEN");
        }
    }

    private void checkCycle(Category category) {
        if (category.getSubCategories() == null || category.getSubCategories().isEmpty()) {
            this.checkCycleRec(category, new ArrayList());
        } else {
            category.getSubCategories().forEach(s -> this.checkCycleRec(s, new ArrayList()));
        }
    }

    private void checkCycleRec(Category curr, List<Category> visited) {
        if (curr == null) {
            return;
        }
        if (!visited.stream().noneMatch(c -> c.getId().equals(curr.getId()))) {
            StringBuilder sb = new StringBuilder(curr.getName() + "(" + curr.getId() + ")");
            for (int i = visited.size() - 1; i >= 0; --i) {
                sb.append(" -> ").append(visited.get(i).getName()).append("(").append(visited.get(i).getId()).append(")");
                if (visited.get(i).getId().equals(curr.getId())) break;
            }
            throw new RuntimeException("CYCLE_HAS_FOUND : " + String.valueOf(sb));
        }
        visited.add(curr);
        this.checkCycleRec(curr.getParentCategory(), visited);
    }
}

