/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.repository;

import com.becon.opencelium.backend.database.mysql.entity.OperationUsageHistory;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OperationUsageHistoryRepository
extends JpaRepository<OperationUsageHistory, Long> {
    public Optional<OperationUsageHistory> findByConnectionTitle(String var1);

    public Page<OperationUsageHistory> findAll(Pageable var1);

    @Query(value="SELECT DISTINCT h FROM OperationUsageHistory h JOIN h.details d WHERE (:startDate IS NULL OR d.startDate >= :startDate) AND (:endDate IS NULL OR d.startDate <= :endDate)")
    public Page<OperationUsageHistory> findAllByDetailsStartDateBetween(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2, Pageable var3);

    @Modifying
    @Query(value="UPDATE operation_usage_history SET total_usage = total_usage + :opsUsage WHERE id = :id", nativeQuery=true)
    public int incrementUsageByConnectionTitle(@Param(value="id") Long var1, @Param(value="opsUsage") long var2);

    @Query(value="SELECT h FROM OperationUsageHistory h JOIN h.details d WHERE (:startDate IS NULL OR d.startDate >= :startDate) AND (:endDate IS NULL OR d.startDate <= :endDate) GROUP BY h.id HAVING SUM(d.operationUsage) > 0")
    public Page<OperationUsageHistory> findAllByTotalUsageGreaterThan(Pageable var1, @Param(value="startDate") LocalDateTime var2, @Param(value="endDate") LocalDateTime var3);
}

