/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.RoleHasPermission;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.resource.user.UserRoleResource;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="role")
public class UserRole {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(name="name")
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="icon")
    private String icon;
    @Transient
    @OneToOne(mappedBy="userRole")
    private User user;
    @OneToMany(mappedBy="userRole", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<RoleHasPermission> components = new HashSet();

    public UserRole() {
    }

    public UserRole(UserRoleResource userRoleResource) {
        this.id = userRoleResource.getGroupId();
        this.name = userRoleResource.getName();
        this.description = userRoleResource.getDescription();
        this.icon = userRoleResource.getIcon();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<RoleHasPermission> getComponents() {
        return this.components;
    }

    public void setComponents(Set<RoleHasPermission> components) {
        this.components = components;
    }
}

