/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.resource.user.UserDetailResource;
import com.becon.opencelium.backend.utility.StringUtility;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="detail")
public class UserDetail {
    @Id
    private int id;
    @MapsId
    @OneToOne
    @JoinColumn(name="user_id")
    private User user;
    @Column(name="name")
    private String name;
    @Column(name="surname")
    private String surname;
    @Column(name="title")
    private String title;
    @Column(name="phone_number")
    private String phoneNumber;
    @Column(name="department")
    private String department;
    @Column(name="organization")
    private String organization;
    @Column(name="profile_picture")
    private String profilePicture;
    @Column(name="tutorial")
    private Boolean tutorial;
    @Column(name="theme")
    private String theme;
    @Column(name="theme_sync")
    private boolean themeSync;
    @Column(name="lang")
    private String lang;
    @Column(name="repo_user")
    private String repoUser;
    @Column(name="repo_password")
    private String repoPassword;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=false)
    private Date createdAt;
    @UpdateTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_at")
    private Date updatedAt;

    public UserDetail() {
    }

    public UserDetail(UserDetailResource userDetailResource) {
        this.name = userDetailResource.getName();
        this.surname = userDetailResource.getSurname();
        this.phoneNumber = userDetailResource.getPhoneNumber();
        this.organization = userDetailResource.getOrganization();
        this.department = userDetailResource.getDepartment();
        this.title = userDetailResource.getUserTitle();
        this.profilePicture = StringUtility.findImageFromUrl((String)userDetailResource.getProfilePicture());
        this.tutorial = userDetailResource.isAppTour();
        this.theme = userDetailResource.getTheme();
        this.themeSync = userDetailResource.isThemeSync();
        this.lang = userDetailResource.getLang();
        this.repoUser = userDetailResource.getBitbucketUser();
        this.repoPassword = userDetailResource.getBitbucketPassword();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProfilePicture() {
        return this.profilePicture;
    }

    public void setProfilePicture(String profilePicture) {
        this.profilePicture = profilePicture;
    }

    public Boolean getTutorial() {
        return this.tutorial;
    }

    public void setTutorial(Boolean tutorial) {
        this.tutorial = tutorial;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getRepoUser() {
        return this.repoUser;
    }

    public void setRepoPassword(String repoPassword) {
        this.repoPassword = repoPassword;
    }

    public boolean isThemeSync() {
        return this.themeSync;
    }

    public void setThemeSync(boolean themeSync) {
        this.themeSync = themeSync;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }
}

