/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.subscription.enums.ExtraOpsStatus;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="extra_ops")
public class ExtraOps {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subscription_id", nullable=false)
    private Subscription subscription;
    @Column(name="start_date", nullable=false)
    private LocalDateTime startDate;
    @Column(name="end_date", nullable=false)
    private LocalDateTime endDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false, length=50)
    private ExtraOpsStatus status;
    @Column(name="current_ops_usage", nullable=false)
    private long currentOpsUsage;
    @Column(name="current_ops_usage_hmac", nullable=false)
    private String currentOpsUsageHmac;
    @Column(name="total_ops_usage", nullable=false)
    private long totalOpsUsage;
    @Column(name="total_ops_usage_hmac", nullable=false)
    private String totalOpsUsageHmac;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @Column(name="generated_at", nullable=false, updatable=false)
    private long generatedAt;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(long unixTime) {
        this.startDate = this.endDate = Instant.ofEpochMilli(unixTime).atZone(ZoneId.of("UTC")).toLocalDateTime();
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(long unixTime) {
        this.endDate = Instant.ofEpochMilli(unixTime).atZone(ZoneId.of("UTC")).toLocalDateTime();
    }

    public ExtraOpsStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExtraOpsStatus status) {
        this.status = status;
    }

    public long getCurrentOpsUsage() {
        return this.currentOpsUsage;
    }

    public void setCurrentOpsUsage(long currentOpsUsage) {
        this.currentOpsUsage = currentOpsUsage;
    }

    public String getCurrentOpsUsageHmac() {
        return this.currentOpsUsageHmac;
    }

    public void setCurrentOpsUsageHmac(String currentOpsUsageHmac) {
        this.currentOpsUsageHmac = currentOpsUsageHmac;
    }

    public long getTotalOpsUsage() {
        return this.totalOpsUsage;
    }

    public void setTotalOpsUsage(long totalOpsUsage) {
        this.totalOpsUsage = totalOpsUsage;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getTotalOpsUsageHmac() {
        return this.totalOpsUsageHmac;
    }

    public void setTotalOpsUsageHmac(String totalOpsUsageHmac) {
        this.totalOpsUsageHmac = totalOpsUsageHmac;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public long getGeneratedAt() {
        return this.generatedAt;
    }

    public void setGeneratedAt(long generatedAt) {
        this.generatedAt = generatedAt;
    }
}

