/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="connector")
@EntityListeners(value={AuditingEntityListener.class})
public class Connector {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @NotNull
    @NotEmpty
    @Column(name="title")
    private String title;
    @NotEmpty
    @NotNull
    @Column(name="invoker")
    private String invoker;
    @Column(name="description")
    private String description;
    @CreatedBy
    @Column(name="created_by", updatable=false)
    private Integer createdBy;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_on", updatable=false)
    private Date createdOn;
    @LastModifiedBy
    @Column(name="modified_by")
    private Integer modifiedBy;
    @UpdateTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_on")
    private Date modifiedOn;
    @Column(name="icon")
    private String icon;
    @Column(name="ssl_validation")
    private boolean sslValidation;
    @Column(name="timeout")
    private int timeout;
    @OneToMany(mappedBy="connector", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<RequestData> requestData = new ArrayList();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInvoker() {
        return this.invoker;
    }

    public void setInvoker(String invoker) {
        this.invoker = invoker;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Integer getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Integer modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isSslValidation() {
        return this.sslValidation;
    }

    public void setSslValidation(boolean sslValidation) {
        this.sslValidation = sslValidation;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<RequestData> getRequestData() {
        return this.requestData;
    }

    public void setRequestData(List<RequestData> requestData) {
        this.requestData = requestData;
    }
}

