/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mongodb.service;

import com.becon.opencelium.backend.database.mongodb.entity.OperatorMng;
import com.becon.opencelium.backend.database.mongodb.repository.OperatorMngRepository;
import com.becon.opencelium.backend.database.mongodb.service.OperatorMngService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.ocel.OCExpressionHelper;
import com.becon.opencelium.backend.ocel.Validator;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.connection.ConnectorDTO;
import com.becon.opencelium.backend.resource.connection.OperatorDTO;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OperatorMngServiceImp
implements OperatorMngService {
    private final OperatorMngRepository operatorMngRepository;
    private final PatchHelper patchHelper;
    private final Mapper<OperatorMng, OperatorDTO> operatorMngMapper;
    private final Validator ocelValidator;

    public OperatorMngServiceImp(OperatorMngRepository operatorMngRepository, PatchHelper patchHelper, Mapper<OperatorMng, OperatorDTO> operatorMngMapper) {
        this.operatorMngRepository = operatorMngRepository;
        this.patchHelper = patchHelper;
        this.operatorMngMapper = operatorMngMapper;
        this.ocelValidator = Validator.defaultValidator();
    }

    public List<OperatorMng> saveAll(List<OperatorMng> operators) {
        operators.forEach(arg_0 -> this.validateExpression(arg_0));
        return this.operatorMngRepository.saveAll(operators);
    }

    public OperatorMng save(OperatorMng operatorMng) {
        this.validateExpression(operatorMng);
        return (OperatorMng)this.operatorMngRepository.save((Object)operatorMng);
    }

    public void deleteById(String id) {
        this.delete(this.getById(id));
    }

    public void delete(OperatorMng operatorMng) {
        this.operatorMngRepository.delete((Object)operatorMng);
    }

    public OperatorMng getById(String id) {
        return (OperatorMng)this.operatorMngRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("OPERATOR_NOT_FOUND"));
    }

    public void deleteAll(List<OperatorMng> operators) {
        this.operatorMngRepository.deleteAllById(operators.stream().map(OperatorMng::getId).toList());
    }

    public void doWithPatchedOperator(ConnectorDTO connectorDTO, ConnectorDTO patched, PatchConnectionDetails.PatchOperationDetail opDetail) {
        if (opDetail.isOperatorAdded()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfOperator().intValue(), patched.getOperators().size());
            OperatorDTO toSave = (OperatorDTO)patched.getOperators().get(idx);
            toSave.setId(null);
            this.validateExpression(toSave.getExpression(), toSave.getType());
            OperatorMng saved = this.save((OperatorMng)this.operatorMngMapper.toEntity((Object)toSave));
            ((OperatorDTO)patched.getOperators().get(idx)).setId(saved.getId());
        } else if (opDetail.isOperatorDeleted()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfOperator().intValue(), connectorDTO.getOperators().size());
            this.deleteById(((OperatorDTO)connectorDTO.getOperators().get(idx)).getId());
        } else if (opDetail.isOperatorReplaced()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfOperator().intValue(), patched.getOperators().size());
            this.deleteById(((OperatorDTO)connectorDTO.getOperators().get(idx)).getId());
            OperatorDTO toSave = (OperatorDTO)patched.getOperators().get(idx);
            this.validateExpression(toSave.getExpression(), toSave.getType());
            OperatorMng saved = this.save((OperatorMng)this.operatorMngMapper.toEntity((Object)toSave));
            ((OperatorDTO)patched.getOperators().get(idx)).setId(saved.getId());
        } else if (opDetail.isOperatorModified()) {
            int idx = this.patchHelper.getIndexOfList(opDetail.getIndexOfOperator().intValue(), patched.getOperators().size());
            List operators = patched.getOperators();
            OperatorDTO toModify = (OperatorDTO)operators.get(idx);
            this.validateExpression(toModify.getExpression(), toModify.getType());
            try {
                this.getById(toModify.getId());
            }
            catch (RuntimeException e) {
                toModify.setId(((OperatorDTO)connectorDTO.getOperators().get(idx)).getId());
            }
            this.save((OperatorMng)this.operatorMngMapper.toEntity((Object)toModify));
        } else {
            if (connectorDTO != null && connectorDTO.getOperators() != null) {
                connectorDTO.getOperators().forEach(o -> this.deleteById(o.getId()));
            }
            if (patched != null && patched.getOperators() != null) {
                patched.getOperators().forEach(o -> this.validateExpression(o.getExpression(), o.getType()));
                patched.getOperators().forEach(o -> {
                    OperatorMng saved = this.save((OperatorMng)this.operatorMngMapper.toEntity(o));
                    o.setId(saved.getId());
                });
            }
        }
    }

    private void validateExpression(OperatorMng operator) {
        this.validateExpression(operator.getExpression(), operator.getType());
    }

    private void validateExpression(String exp, String type) {
        if ("if".equals(type)) {
            this.ocelValidator.validate(exp);
        } else {
            OCExpressionHelper.validateLoopExp((String)exp);
        }
    }
}

