/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.entity.Webhook;
import com.becon.opencelium.backend.database.mysql.service.SchedulerServiceImp;
import com.becon.opencelium.backend.database.mysql.service.WebhookServiceImp;
import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.webhook.WebhookResource;
import com.becon.opencelium.backend.resource.webhook.WebhookTokenResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@Tag(name="Webhook", description="Manages operations related to webhook management")
@RequestMapping(value={"/webhook"})
public class WebhookController {
    @Autowired
    private SchedulerServiceImp schedulerService;
    @Autowired
    private WebhookServiceImp webhookService;

    @Operation(summary="Accepts a webhook and executes the associated connection. Additional params are sent in url query params")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Webhook has been successfully executed"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"execute/{token}"})
    public ResponseEntity<?> executeConnection(@PathVariable(value="token") String token, @RequestParam Map<String, Object> queryParam) {
        WebhookTokenResource webhookToken = this.webhookService.getTokenObject(token).orElse(null);
        if (webhookToken == null) {
            throw new RuntimeException("TOKEN_NOT_FOUND");
        }
        Webhook webhook = this.webhookService.findByUIID(webhookToken.getUuid()).orElse(null);
        if (webhook == null) {
            throw new RuntimeException("WEBHOOK_NOT_FOUND");
        }
        if (!webhook.getUuid().equals(webhookToken.getUuid())) {
            throw new RuntimeException("WEBHOOK_UUID_WRONG");
        }
        Scheduler scheduler = this.schedulerService.findById(webhookToken.getSchedulerId()).orElse(null);
        if (scheduler == null) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        try {
            if (queryParam.isEmpty()) {
                this.schedulerService.startNow(scheduler);
            } else {
                this.schedulerService.startNow(scheduler, this.webhookService.convertToArrayList(queryParam));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Accepts a webhook and executes the associated connection. Additional params are sent as a json in body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Webhook has been successfully executed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"execute/{token}"})
    public ResponseEntity<?> executeConn(@PathVariable(value="token") String token, @RequestBody Map<String, Object> payload, @RequestParam Map<String, Object> queryParam) {
        WebhookTokenResource webhookToken = this.webhookService.getTokenObject(token).orElse(null);
        if (webhookToken == null) {
            throw new RuntimeException("TOKEN_NOT_FOUND");
        }
        Webhook webhook = this.webhookService.findByUIID(webhookToken.getUuid()).orElse(null);
        if (webhook == null) {
            throw new RuntimeException("WEBHOOK_NOT_FOUND");
        }
        if (!webhook.getUuid().equals(webhookToken.getUuid())) {
            throw new RuntimeException("WEBHOOK_UUID_WRONG");
        }
        Scheduler scheduler = this.schedulerService.findById(webhookToken.getSchedulerId()).orElse(null);
        if (scheduler == null) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        try {
            if (payload.isEmpty()) {
                this.schedulerService.startNow(scheduler);
            } else {
                this.schedulerService.startNow(scheduler, this.webhookService.mergeParams(payload, queryParam));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Checks if the remote server is up and running.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Server is up and running", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/health"})
    public ResponseEntity<?> checkHealth() {
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Generates webhook by given user and scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Webhook has been successfully executed", content={@Content(schema=@Schema(implementation=WebhookResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/url/{userId}/{schedulerId}"})
    public ResponseEntity<?> generateUrl(@PathVariable(value="userId") int userId, @PathVariable(value="schedulerId") int schedulerId) {
        Scheduler scheduler = this.schedulerService.findById(schedulerId).orElse(null);
        if (scheduler == null) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        if (scheduler.getWebhook() != null) {
            throw new RuntimeException("SCHEDULER_HAS_WEBHOOK");
        }
        Webhook webhook = this.webhookService.save(userId, scheduler);
        WebhookResource resource = this.webhookService.toResource(webhook);
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }

    @Operation(summary="Returns supported data types for query parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data types successfully returned", content={@Content(schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/supported/types"})
    public ResponseEntity<?> generateSupportedDataTypes() {
        return ResponseEntity.ok((Object)DataType.getTypes());
    }

    @Operation(summary="Removes webhook")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Webhook has been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{webhookId}"})
    public ResponseEntity<?> deleteWebhook(@PathVariable int webhookId) {
        this.webhookService.deleteById(webhookId);
        return ResponseEntity.noContent().build();
    }
}

