/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.UserDetail;
import com.becon.opencelium.backend.database.mysql.service.UserDetailServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.UserDetailResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@Tag(name="User Details", description="Stores detailed information about users")
@RequestMapping(value={"/userDetail"}, produces={"application/json"})
public class UserDetailController {
    @Autowired
    private UserDetailServiceImpl userDetailService;
    @Autowired
    private UserServiceImpl userService;

    @Operation(summary="Updates user details")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User detail has been modified successfully.", content={@Content(schema=@Schema(implementation=UserDetailResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<UserDetailResource> put(@Parameter(description="Unique identifier of User") @PathVariable(value="id") int id, @RequestBody UserDetailResource userDetailResource) throws IOException {
        if (!this.userDetailService.existsById(id)) {
            throw new RuntimeException("USER_DETAIL_NOT_FOUND");
        }
        UserDetail userDetail = this.userDetailService.toEntity(userDetailResource);
        userDetail.setId(id);
        this.userDetailService.save(userDetail);
        User user = (User)this.userService.findById(id).orElseThrow(() -> new RuntimeException("User not found"));
        userDetail.setUser(user);
        UserDetailResource resource = new UserDetailResource(userDetail);
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }
}

