/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.service.SessionServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.TotpService;
import com.becon.opencelium.backend.database.mysql.service.UserRoleServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.enums.LangEnum;
import com.becon.opencelium.backend.exception.EmailAlreadyExistException;
import com.becon.opencelium.backend.exception.RoleNotFoundException;
import com.becon.opencelium.backend.exception.SessionNotFoundException;
import com.becon.opencelium.backend.exception.UserNotFoundException;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.request.UserRequestResource;
import com.becon.opencelium.backend.resource.user.UserDetailResource;
import com.becon.opencelium.backend.resource.user.UserResource;
import com.becon.opencelium.backend.security.UserPrincipals;
import com.becon.opencelium.backend.storage.StorageService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@Tag(name="User", description="Manages operations related to user management")
@RequestMapping(value={"/user"}, produces={"application/json"})
public class UserController {
    @Autowired
    private UserServiceImpl userService;
    @Autowired
    private UserRoleServiceImpl userRoleService;
    @Autowired
    private SessionServiceImpl sessionService;
    @Autowired
    private StorageService storageService;
    @Autowired
    private TotpService totpService;

    @Operation(summary="Retrieves user data from the database based on the provided user 'id'")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The user has been successfully retrieved", content={@Content(schema=@Schema(implementation=UserResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> get(@PathVariable(value="id") int id) throws IOException {
        return this.userService.findById(id).map(p -> ResponseEntity.ok((Object)new UserResource(p))).orElseThrow(() -> new UserNotFoundException(id));
    }

    @Operation(summary="Checks the existence of an user email in the system")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The email address exists in the system.", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/check/{email}"})
    public ResponseEntity<?> emailExists(@PathVariable(value="email") String email) {
        if (this.userService.existsByEmail(email)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.OK, "EXISTS");
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.OK, "NOT_EXISTS");
    }

    @Operation(summary="Retrieves a list of all users in the application")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns list of users", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<UserResource>> all() {
        List userResources = this.userService.findAll().stream().map(UserResource::new).collect(Collectors.toList());
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        return ResponseEntity.created((URI)uri).body(userResources);
    }

    @Operation(summary="Creates a new user in the system by accepting user data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is successfully created. The 'id' property will include newly created user's 'id'", content={@Content(schema=@Schema(implementation=UserResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> post(@RequestBody UserRequestResource userRequestResource) throws IOException {
        if (this.userService.existsByEmail(userRequestResource.getEmail())) {
            throw new EmailAlreadyExistException(userRequestResource.getEmail());
        }
        if (!this.userRoleService.existsById(userRequestResource.getUserGroup())) {
            throw new RoleNotFoundException(userRequestResource.getUserGroup());
        }
        UserDetailResource userDetailResource = userRequestResource.getUserDetail();
        if (userDetailResource.getLang() == null || userDetailResource.getLang().isEmpty()) {
            userDetailResource.setLang(LangEnum.EN.getCode());
            userRequestResource.setUserDetail(userDetailResource);
        } else {
            LangEnum.valueOf((String)userDetailResource.getLang().toUpperCase(Locale.ROOT));
        }
        User user = this.userService.requestToEntity(userRequestResource);
        this.userService.save(user);
        UserResource userResource = this.userService.toResource(user);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{user.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)userResource);
    }

    @Operation(summary="Updates an existed user in the system by accepting user data in the request body ")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is successfully updated.", content={@Content(schema=@Schema(implementation=UserResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> update(@PathVariable(value="id") int id, @RequestBody UserRequestResource userRequestResource) throws IOException {
        if (!this.userService.existsById(id)) {
            throw new UserNotFoundException(id);
        }
        userRequestResource.setUserId(id);
        UserDetailResource userDetailResource = userRequestResource.getUserDetail();
        if (userDetailResource.getLang() == null || userDetailResource.getLang().isEmpty()) {
            userDetailResource.setLang("en");
            userRequestResource.setUserDetail(userDetailResource);
        }
        User user = this.userService.requestToEntity(userRequestResource);
        this.userService.save(user);
        return ResponseEntity.ok().body((Object)userRequestResource);
    }

    @Operation(summary="Deletes a user by 'id' ")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="User is successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") int id) {
        return this.userService.findById(id).map(p -> {
            if (p.getUserDetail().getProfilePicture() != null) {
                this.storageService.delete(p.getUserDetail().getProfilePicture());
            }
            this.userService.deleteById(id);
            return ResponseEntity.noContent().build();
        }).orElseThrow(() -> new UserNotFoundException(id));
    }

    @Operation(summary="Deletes users by ids ")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Users are successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteUsersById(@RequestBody IdentifiersDTO<Integer> payload) {
        payload.getIdentifiers().forEach(id -> {
            User p = (User)this.userService.findById(id.intValue()).orElseThrow(() -> new UserNotFoundException(id.intValue()));
            if (p.getUserDetail().getProfilePicture() != null) {
                this.storageService.delete(p.getUserDetail().getProfilePicture());
            }
            this.userService.deleteById(id.intValue());
        });
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Logs out the currently authenticated user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is successfully logged out.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}/logout"})
    public ResponseEntity<?> logout(@PathVariable(value="id") int userId) {
        return this.sessionService.findByUserId(userId).map(s -> {
            s.setActive(false);
            this.sessionService.save(s);
            return ResponseEntity.ok().build();
        }).orElseThrow(() -> new SessionNotFoundException(userId));
    }

    @Operation(summary="Enables or disables TOTP to a user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="TOTP is successfully enabled or disabled to user", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/{id}/totp/{action}"}, consumes={"application/json"})
    public ResponseEntity<?> totpAction(@PathVariable(value="id") int userId, @PathVariable(value="action") String action) {
        this.totpService.totpAction(userId, action);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Enables or disables TOTP to users by ids")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="TOTP is successfully enabled or disabled to users", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/list/totp/{action}"}, consumes={"application/json"})
    public ResponseEntity<?> totpsAction(@PathVariable(value="action") String action, @RequestBody IdentifiersDTO<Integer> payload) {
        payload.getIdentifiers().forEach(userId -> this.totpService.totpAction(userId.intValue(), action));
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Returns status of QR code by secretKey.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QR and Secret Key existed already.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/totp-qr/exists"})
    public ResponseEntity<?> isQRCodeExists() {
        int userId = this.getCurrentUserId();
        User user = (User)this.userService.findById(userId).orElseThrow(() -> new UserNotFoundException(userId));
        ResultDTO resultDTO = new ResultDTO();
        resultDTO.setResult((Object)false);
        if (user.getTotpSecretKey() != null) {
            resultDTO.setResult((Object)true);
        }
        return ResponseEntity.ok((Object)resultDTO);
    }

    private int getCurrentUserId() {
        UserPrincipals userPrincipals = (UserPrincipals)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return userPrincipals.getUser().getId();
    }
}

