/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.service.ConnectorServiceImp;
import com.becon.opencelium.backend.exception.ConnectorNotFoundException;
import com.becon.opencelium.backend.exception.StorageFileNotFoundException;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.template.TemplateResource;
import com.becon.opencelium.backend.template.entity.Template;
import com.becon.opencelium.backend.template.service.TemplateServiceImp;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Template", description="Manages operations related to template")
@RequestMapping(value={"/template"}, produces={"application/json"})
public class TemplateController {
    @Autowired
    private TemplateServiceImp templateService;
    @Autowired
    private ConnectorServiceImp connectorService;

    @Operation(summary="Retrieves a template from the database based on the provided template 'id'")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been retrieved successfully", content={@Content(schema=@Schema(implementation=TemplateResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> get(@PathVariable String id) {
        Template template = (Template)this.templateService.findById(id).orElseThrow(() -> new RuntimeException("TEMPLATE_NOT_FOUND"));
        TemplateResource templateResource = this.templateService.toResource(template);
        return ResponseEntity.ok().body((Object)templateResource);
    }

    @Operation(summary="Retrieves a template from the database based on the provided connectionId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been retrieved successfully", content={@Content(schema=@Schema(implementation=TemplateResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/connection/{connectionId}"})
    public ResponseEntity<?> getByConnectionId(@PathVariable Long connectionId) {
        TemplateResource resource = this.templateService.getByConnectionId(connectionId);
        return ResponseEntity.ok().body((Object)resource);
    }

    @Operation(summary="Checks if a template with given id is exists or not")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Exists or not ", content={@Content(schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/check/{id}"})
    public ResponseEntity<Boolean> exists(@PathVariable String id) {
        return ResponseEntity.ok((Object)this.templateService.existsById(id));
    }

    @Operation(summary="Retrieves templates from database based on 'from' and 'to' connector 'id's")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Templates for connectors have been retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TemplateResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all/{fromConnectorId}/{toConnectorId}"})
    public ResponseEntity<List<TemplateResource>> getAllByConnectors(@PathVariable int fromConnectorId, @PathVariable int toConnectorId) {
        Connector fromConnector = (Connector)this.connectorService.findById(fromConnectorId).orElseThrow(() -> new ConnectorNotFoundException(fromConnectorId));
        Connector toConnector = (Connector)this.connectorService.findById(toConnectorId).orElseThrow(() -> new ConnectorNotFoundException(toConnectorId));
        List templates = this.templateService.findByFromInvokerAndToInvoker(fromConnector.getInvoker(), toConnector.getInvoker());
        if (templates.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        ArrayList templateResources = new ArrayList();
        templates.forEach(t -> {
            TemplateResource templateResource = this.templateService.toResource(t);
            templateResource.getConnection().getFromConnector().setConnectorId(Integer.valueOf(fromConnectorId));
            templateResource.getConnection().getToConnector().setConnectorId(Integer.valueOf(toConnectorId));
            templateResources.add(templateResource);
        });
        return ResponseEntity.ok().body(templateResources);
    }

    @Operation(summary="Retrieves all templates from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All templates have been retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TemplateResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<TemplateResource>> getAll() {
        List templates = this.templateService.findAll();
        if (templates.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        ArrayList templateResources = new ArrayList();
        templates.forEach(t -> {
            if (t == null) {
                return;
            }
            TemplateResource templateResource = this.templateService.toResource(t);
            templateResources.add(templateResource);
        });
        return ResponseEntity.ok().body(templateResources);
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> save(@RequestBody TemplateResource templateResource) throws JsonProcessingException {
        String templateId = "";
        try {
            String id = UUID.randomUUID().toString();
            templateResource.setTemplateId(id);
            Template template = this.templateService.toEntity(templateResource);
            this.templateService.save(template);
            templateId = template.getTemplateId();
            EntityModel resource = EntityModel.of((Object)this.templateService.toResource(template));
            return ResponseEntity.ok().body((Object)resource);
        }
        catch (Exception e) {
            this.templateService.deleteById(templateId);
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Downloads template by given filename")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been successfully downloaded", content={@Content(schema=@Schema(implementation=byte[].class))}, headers={@Header(name="Content-Disposition", description="attachment; filename=\"example-file.json\"")}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @ResponseBody
    @GetMapping(value={"/file/{filename:.+}"})
    public ResponseEntity<Resource> download(@PathVariable String filename) {
        try {
            Path rootLocation = Paths.get("runtime/templates/", new String[0]);
            Path filePath = rootLocation.resolve(filename);
            UrlResource file = new UrlResource(filePath.toUri());
            if (!file.exists() || !file.isReadable()) {
                throw new StorageFileNotFoundException("Could not read file: " + filename);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
        }
        catch (MalformedURLException e) {
            throw new StorageFileNotFoundException("Could not read file: " + filename, (Throwable)e);
        }
    }

    @Operation(summary="Modifies template by given id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been successfully modified", content={@Content(schema=@Schema(implementation=TemplateResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> modify(@RequestBody TemplateResource templateResource) throws JsonProcessingException {
        Template template = this.templateService.toEntity(templateResource);
        if (this.templateService.existsById(template.getTemplateId())) {
            this.templateService.deleteById(templateResource.getTemplateId());
        }
        this.templateService.save(template);
        EntityModel resource = EntityModel.of((Object)this.templateService.toResource(template));
        return ResponseEntity.ok().body((Object)resource);
    }

    @Operation(summary="Modifies a list of templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been successfully modified", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TemplateResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/all"}, consumes={"application/json"})
    public ResponseEntity<?> modifyAll(@RequestBody List<TemplateResource> templateResources) throws JsonProcessingException {
        templateResources.forEach(tr -> {
            Template template = this.templateService.toEntity(tr);
            if (this.templateService.existsById(template.getTemplateId())) {
                this.templateService.deleteById(tr.getTemplateId());
            }
            this.templateService.save(template);
        });
        return ResponseEntity.ok().body(templateResources);
    }

    @Operation(summary="Removes a template by given id")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Template has been successfully removed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable String id) {
        this.templateService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Removes templates by given list of ids")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Templates have been successfully removed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/list/delete"})
    public ResponseEntity<?> deleteTemplateByIdIn(@RequestBody IdentifiersDTO<String> ids) {
        ids.getIdentifiers().forEach(id -> this.templateService.deleteById(id));
        return ResponseEntity.noContent().build();
    }
}

