/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.execution.supportfile.SupportFile;
import com.becon.opencelium.backend.execution.supportfile.SupportFileService;
import com.becon.opencelium.backend.resource.connection.SupportFileNamesDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.ComponentResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Support files for Connections", description="Manages connection execution related support files")
@RequestMapping(value={"/connection/support-file"})
public class SupportFileController {
    @Autowired
    private SupportFileService fileService;

    @Operation(summary="Retrieves all support file names")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Support files names have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/list"})
    public ResponseEntity<List<SupportFile>> supportFileList() {
        return ResponseEntity.ok((Object)this.fileService.supportFileList());
    }

    @Operation(summary="Retrieves support file names for a connection")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Support files names have been successfully retrieved for a connection", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{connectionId}/list"})
    public ResponseEntity<List<SupportFile>> connectionSupportFileList(@PathVariable Long connectionId) {
        return ResponseEntity.ok((Object)this.fileService.connectionSupportFileList(connectionId));
    }

    @Operation(summary="Retrieves support file for a connection")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Support file have been successfully retrieved for a connection", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{connectionId}/{zipFileName}"})
    public ResponseEntity<Resource> downloadSupportFile(@PathVariable Long connectionId, @PathVariable String zipFileName) {
        File zip = this.fileService.getSupportFile(connectionId, zipFileName);
        FileSystemResource resource = new FileSystemResource(zip);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=" + zip.getName());
        headers.add("Content-Type", "application/octet-stream");
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Retrieves support file for successful execution")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Support file  for successful execution have been successfully retrieved.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{connectionId}"})
    public ResponseEntity<Resource> downloadSupportFile(@PathVariable Long connectionId) {
        File zip = this.fileService.getSupportFile(connectionId);
        FileSystemResource resource = new FileSystemResource(zip);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=" + zip.getName());
        headers.add("Content-Type", "application/octet-stream");
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Deletes support file by file name")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Support file has been successfully deleted", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{zipFileName}"})
    public ResponseEntity<Void> deleteSupportFile(@PathVariable String zipFileName) {
        this.fileService.deleteSupportFile(zipFileName);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes support files by file names")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Support files have been successfully deleted", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/delete/list"})
    public ResponseEntity<Void> deleteSupportFiles(@RequestBody SupportFileNamesDTO dto) {
        dto.getFilenames().forEach(arg_0 -> ((SupportFileService)this.fileService).deleteSupportFile(arg_0));
        return ResponseEntity.noContent().build();
    }
}

