/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.InvokerSyncService;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.parser.InvokerParserImp;
import com.becon.opencelium.backend.invoker.resource.OperationResource;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.mapper.mysql.invoker.InvokerMapper;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.connector.FunctionDTO;
import com.becon.opencelium.backend.resource.connector.InvokerDTO;
import com.becon.opencelium.backend.resource.connector.InvokerXMLResource;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.utility.PathUtility;
import com.becon.opencelium.backend.utility.Xml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.StringReader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(name="Invoker", description="Manages operations related to Invoker management")
@RequestMapping(value={"/invoker"}, produces={"application/json"})
public class InvokerController {
    private final InvokerService invokerService;
    private final InvokerSyncService invokerSyncService;
    private final ConnectorService connectorService;
    private final ConnectionService connectionService;
    private final Mapper<Invoker, InvokerDTO> invokerMapper;
    private final Mapper<FunctionInvoker, FunctionDTO> functionMapper;

    public InvokerController(@Qualifier(value="invokerServiceImp") InvokerService invokerService, @Qualifier(value="connectorServiceImp") ConnectorService connectorService, @Qualifier(value="connectionServiceImp") ConnectionService connectionService, InvokerSyncService invokerSyncService, Mapper<Invoker, InvokerDTO> invokerMapper, Mapper<FunctionInvoker, FunctionDTO> functionMapper) {
        this.invokerService = invokerService;
        this.invokerSyncService = invokerSyncService;
        this.connectorService = connectorService;
        this.connectionService = connectionService;
        this.invokerMapper = invokerMapper;
        this.functionMapper = functionMapper;
    }

    @Operation(summary="Retrieves an 'invoker' based on the provided invoker 'name'")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully retrieved", content={@Content(schema=@Schema(implementation=InvokerDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{name}"})
    public ResponseEntity<?> get(@PathVariable String name) throws Exception {
        InvokerDTO invokerResources = (InvokerDTO)this.invokerMapper.toDTO((Object)this.invokerService.findByName(name));
        return ResponseEntity.ok((Object)this.setManualChangeValue(invokerResources));
    }

    @Operation(summary="Retrieves all invokers", parameters={@Parameter(name="opsIncluded", description="Whether to include operations for each invoker", example="false", schema=@Schema(defaultValue="true"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of Invokers have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InvokerDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<InvokerDTO>> getAll(@RequestParam(name="opsIncluded", defaultValue="true") boolean opsIncluded) throws Exception {
        List invokers = this.invokerService.findAll();
        InvokerMapper invokerMappers = (InvokerMapper)this.invokerMapper;
        List invokerDTOS = invokers.stream().map(invoker -> opsIncluded ? invokerMappers.toDTO(invoker) : invokerMappers.toDTONoOps(invoker)).map(arg_0 -> this.setManualChangeValue(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(invokerDTOS);
    }

    @Operation(summary="Checks by name whether an invoker exist or not")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Property 'result' contains a boolean value true(exists) or false(not exists)", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/exists/{invokerName}"})
    public ResponseEntity<ResultDTO<Boolean>> existsByName(@PathVariable String invokerName) throws Exception {
        Boolean result = this.invokerService.existsByName(invokerName);
        ResultDTO resultDTO = new ResultDTO((Object)result);
        return ResponseEntity.ok((Object)resultDTO);
    }

    @Operation(summary="Checks by filename whether an invoker exist or not")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Property 'result' contains a boolean value true(exists) or false(not exists)", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/file/exists/{fileName}"})
    public ResponseEntity<ResultDTO<Boolean>> existsByFileName(@PathVariable String fileName) throws Exception {
        Boolean result = this.invokerService.existsByFileName(fileName);
        ResultDTO resultDTO = new ResultDTO((Object)result);
        return ResponseEntity.ok((Object)resultDTO);
    }

    @Operation(summary="Creates new invoker")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully created", content={@Content(schema=@Schema(implementation=InvokerDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> save(@RequestBody InvokerXMLResource invokerXMLResource) throws Exception {
        Document doc = InvokerController.convertStringToXMLDocument((String)invokerXMLResource.getXml());
        Objects.requireNonNull(doc);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression expression = xpath.compile("/invoker/name");
        String filename = expression.evaluate(doc);
        if (this.invokerService.existsByName(filename)) {
            throw new RuntimeException("INVOKER_ALREADY_EXISTS");
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File("runtime/invoker//" + filename + ".xml"));
            transformer.transform(source, result);
            this.invokerSyncService.updateSync(filename);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.invokerService.refresh();
        }
        catch (Exception e) {
            this.delete(filename);
            throw new RuntimeException(e);
        }
        Invoker invoker = this.invokerService.findByName(filename);
        if (invoker.getOperations() == null) {
            this.delete(filename);
            throw new RuntimeException("Invoker should contain at least one Operation.");
        }
        InvokerDTO invokerDTO = (InvokerDTO)this.invokerMapper.toDTO((Object)invoker);
        return ResponseEntity.ok().body((Object)invokerDTO);
    }

    @Operation(summary="Validates whether an invoker is used in connection or in connector")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Property 'result' contains a boolean value true(has dependency) or false(no dependency)", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{name}/dependency"})
    public ResponseEntity<ResultDTO<Boolean>> hasDependency(@PathVariable String name) {
        Boolean result = this.connectorService.existByInvoker(name);
        ResultDTO resultDTO = new ResultDTO((Object)result);
        return ResponseEntity.ok((Object)resultDTO);
    }

    @Operation(summary="Deletes an invoker by provided invoker 'name' and removes all dependencies")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully removed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{invokerName}/force"})
    public ResponseEntity<?> deleteForce(@PathVariable String invokerName) {
        List connector = this.connectorService.findAllByInvoker(invokerName);
        this.connectorService.deleteByInvoker(invokerName);
        connector.forEach(ctor -> {
            List ctions = this.connectionService.findAllByConnectorId(ctor.getId());
            if (ctions == null) {
                return;
            }
            ctions.forEach(ction -> this.connectionService.deleteAndTrackIt(ction.getId()));
        });
        this.invokerService.delete(invokerName);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes an invoker by provided invoker 'name'. If invoker has dependencies then throws exception.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully removed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{name}"})
    public ResponseEntity<?> delete(@PathVariable String name) {
        if (this.connectorService.existByInvoker(name)) {
            throw new RuntimeException("Couldn't delete because invoker '" + name + "' has references to connector and connection. ");
        }
        this.invokerService.deleteInvokerFile(name);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes a collection of invokers based on the provided list of their corresponding 'names'.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of Invokers have been successfully removed"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteInvokerListByNames(@RequestBody IdentifiersDTO<String> invokerNames) {
        invokerNames.getIdentifiers().forEach(arg_0 -> ((InvokerService)this.invokerService).delete(arg_0));
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Modifies fields in operations by providing invoker name and by accepting 'Operation' data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Field in operation hase been successfully modified", content={@Content(schema=@Schema(implementation=FunctionDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/{invokerName}/xml"}, consumes={"application/json"})
    public ResponseEntity<FunctionDTO> updateField(@PathVariable String invokerName, @RequestBody OperationResource operationResource) {
        try {
            Document invoker = this.invokerService.getDocument(invokerName + ".xml");
            Xml xml = new Xml(invoker, invokerName + ".xml");
            String path = operationResource.getPath();
            String method = operationResource.getMethod();
            String xpath = PathUtility.convertToXpath((String)path, (String)method);
            xml.addFields(xpath, operationResource);
            xml.save();
            this.invokerService.save(invoker);
            NodeList methodNode = xml.getNodeListByXpath(PathUtility.getXPathTillMethod((String)method));
            InvokerParserImp invokerParserImp = new InvokerParserImp(invoker);
            FunctionInvoker functionInvoker = (FunctionInvoker)invokerParserImp.getFunctions(methodNode).get(0);
            FunctionDTO resource = (FunctionDTO)this.functionMapper.toDTO((Object)functionInvoker);
            this.invokerSyncService.updateSync(invokerName);
            return ResponseEntity.ok((Object)resource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Operation(summary="Refreshes all invoker files")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/refresh"})
    public ResponseEntity<?> refresh() {
        this.invokerService.refresh();
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Synchronises invokers in memory with invokers on the server and returns all invokers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/synchronisation"})
    public ResponseEntity<List<InvokerDTO>> synchronise() {
        List invokerDTOS = this.invokerService.synchronise().stream().map(arg_0 -> ((Mapper)this.invokerMapper).toDTO(arg_0)).map(arg_0 -> this.setManualChangeValue(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(invokerDTOS);
    }

    @Operation(summary="Syncs one invoker file with Service Portal by invoker 'name'")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invoker has been successfully synced with Service Portal", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{invokerName}/sync-force"})
    public ResponseEntity<?> syncForce(@PathVariable String invokerName) {
        this.invokerSyncService.forceSync(invokerName);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Syncs invoker files with Service Portal by list of their corresponding 'name's.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of Invokers have been successfully synced with Service Portal"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"list/sync-force"}, consumes={"application/json"})
    public ResponseEntity<?> syncForceByNames(@RequestBody IdentifiersDTO<String> invokerNames) {
        invokerNames.getIdentifiers().forEach(arg_0 -> ((InvokerSyncService)this.invokerSyncService).forceSync(arg_0));
        return ResponseEntity.noContent().build();
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private InvokerDTO setManualChangeValue(InvokerDTO dto) {
        dto.setHasManualSync(this.invokerSyncService.isManuallyModified(dto.getName()));
        return dto;
    }
}

