/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.exception.CommunicationFailedException;
import com.becon.opencelium.backend.exception.ConnectorAlreadyExistsException;
import com.becon.opencelium.backend.exception.ConnectorNotFoundException;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(name="Connector", description="Manages operations related to Connector management")
@RequestMapping(value={"/connector"}, produces={"application/json"})
public class ConnectorController {
    private final ConnectorService connectorService;
    private final InvokerService invokerService;
    private final ConnectionService connectionService;
    private final Mapper<Connector, ConnectorResource> connectorResourceMapper;

    public ConnectorController(@Qualifier(value="connectorServiceImp") ConnectorService connectorService, @Qualifier(value="invokerServiceImp") InvokerService invokerService, @Qualifier(value="connectionServiceImp") ConnectionService connectionService, Mapper<Connector, ConnectorResource> connectorResourceMapper) {
        this.connectorService = connectorService;
        this.invokerService = invokerService;
        this.connectionService = connectionService;
        this.connectorResourceMapper = connectorResourceMapper;
    }

    @Operation(summary="Retrieves a connector from database by provided connector Title")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector has been successfully retrieved", content={@Content(schema=@Schema(implementation=ConnectorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping
    public ResponseEntity<?> getByTitle(@RequestParam String title) {
        return this.connectorService.findAllByTitle(title).map(c -> ResponseEntity.ok().body((Object)((ConnectorResource)this.connectorResourceMapper.toDTO(c)))).orElseThrow(() -> new ConnectorNotFoundException(title));
    }

    @Operation(summary="Retrieves a connector from database by provided connector ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector has been successfully retrieved", content={@Content(schema=@Schema(implementation=ConnectorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{id}"})
    public ResponseEntity<?> get(@PathVariable int id) {
        return this.connectorService.findById(id).map(c -> ResponseEntity.ok().body((Object)((ConnectorResource)this.connectorResourceMapper.toDTO(c)))).orElseThrow(() -> new ConnectorNotFoundException(id));
    }

    @Operation(summary="Retrieves all connectors from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connectors have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectorResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<ConnectorResource>> getAll() {
        List connectorResources = this.connectorResourceMapper.toDTOAll(this.connectorService.findAll());
        return ResponseEntity.ok((Object)connectorResources);
    }

    @Operation(summary="Creates new connector in the system by accepting Connector data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector has been successfully created", content={@Content(schema=@Schema(implementation=ConnectorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> add(@RequestBody ConnectorResource connectorResource) {
        if (this.connectorService.existByTitle(connectorResource.getTitle())) {
            throw new ConnectorAlreadyExistsException("CONNECTOR_ALREADY_EXISTS");
        }
        Connector connector = (Connector)this.connectorResourceMapper.toEntity((Object)connectorResource);
        connector.setId(0);
        Connector saved = this.connectorService.save(connector);
        return ResponseEntity.ok().body((Object)((ConnectorResource)this.connectorResourceMapper.toDTO((Object)saved)));
    }

    @Operation(summary="Modifies a connector in the system by providing connector ID and accepting Connector data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector has been successfully modified", content={@Content(schema=@Schema(implementation=ConnectorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<ConnectorResource> update(@PathVariable Integer id, @RequestBody ConnectorResource connectorResource) {
        return ResponseEntity.ok((Object)((ConnectorResource)this.connectorResourceMapper.toDTO((Object)this.connectorService.update(id, connectorResource))));
    }

    @Operation(summary="Modifies connector's required data")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector's required data has been successfully modified")})
    @PutMapping(path={"/{id}/required-data"})
    public ResponseEntity<ConnectorResource> updateRequiredData(@PathVariable Integer id, @RequestBody Map<String, String> requiredData, @RequestHeader(name="X-Master-Password", required=false) String masterPassword) {
        this.connectorService.verifyMasterPassword(masterPassword);
        this.connectorService.updateRequestData(id, requiredData);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Verifies Master Password")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully verified")})
    @GetMapping(path={"/master-password/status"})
    public ResponseEntity<?> verifyMasterPassword(@RequestHeader(name="X-Master-Password", required=false) String masterPassword) {
        this.connectorService.verifyMasterPassword(masterPassword);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Checks existence of Master Password")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Exists or Not Exists", content={@Content(schema=@Schema(implementation=Boolean.class))})})
    @GetMapping(path={"/master-password/status/exist"})
    public ResponseEntity<Boolean> checkMasterPasswordExist() {
        return ResponseEntity.ok((Object)this.connectorService.existsMasterPassword());
    }

    @Operation(summary="Deletes a connector in the system by providing connector ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Connector has been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable int id) {
        List connections = this.connectionService.findAllByConnectorId(id);
        connections.forEach(c -> this.connectionService.deleteById(c.getId()));
        this.connectorService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes a collection of connector based on the provided list of their corresponding IDs.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Connectors have been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteCtorByIdIn(@RequestBody IdentifiersDTO<Integer> ids) {
        ids.getIdentifiers().forEach(id -> {
            List connections = this.connectionService.findAllByConnectorId(id.intValue());
            connections.forEach(c -> this.connectionService.deleteAndTrackIt(c.getId()));
            this.connectorService.deleteById(id.intValue());
        });
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Checks connection to a remote application where credential are set in connector")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully established to a remote connector"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/check"}, consumes={"application/json"})
    public ResponseEntity<?> checkCommunication(@RequestBody ConnectorResource connectorResource) throws JsonProcessingException, IOException {
        ResponseEntity responseEntity;
        Connector connector = (Connector)this.connectorResourceMapper.toEntity((Object)connectorResource);
        try {
            responseEntity = this.connectorService.checkCommunication(connector);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CommunicationFailedException();
        }
        FunctionInvoker functionInvoker = this.invokerService.getTestFunction(connector.getInvoker());
        Map failBody = null;
        String formatType = "";
        if (functionInvoker.getResponse().getFail() != null && functionInvoker.getResponse().getFail().getBody() != null) {
            formatType = functionInvoker.getResponse().getFail().getBody().getFormat();
            failBody = functionInvoker.getResponse().getFail().getBody().getFields();
        }
        String response = "";
        String fail = ConnectorController.convertMapToJson(failBody);
        if (formatType.equals("json")) {
            System.out.println(responseEntity.getBody());
            response = responseEntity.getBody().toString();
        }
        if (responseEntity.getStatusCode() == HttpStatus.OK && this.hasError(fail, response)) {
            return ResponseEntity.ok().body((Object)"{\"status\":\"401\", \"error\":\"401\"}");
        }
        if (responseEntity.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            return ResponseEntity.ok().body((Object)("{\"status\":\"" + String.valueOf(responseEntity.getStatusCode()) + "\",\"error\":\"Error in remote system\"}"));
        }
        return ResponseEntity.ok().body((Object)"{\"status\":\"200\"}");
    }

    public static String convertMapToJson(Map<String, Object> map) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean hasError(String failBody, String response) {
        if (failBody == null || failBody.isEmpty()) {
            return false;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode invFailNode = objectMapper.readTree(failBody);
            JsonNode responseNode = objectMapper.readTree(response);
            return this.containsProperties(responseNode, invFailNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsProperties(JsonNode jsonNode1, JsonNode jsonNode2) {
        if (jsonNode2.isObject()) {
            for (String key : this.iterable(jsonNode2.fieldNames())) {
                if (!jsonNode1.has(key)) {
                    return false;
                }
                if (this.containsProperties(jsonNode1.get(key), jsonNode2.get(key))) continue;
                return false;
            }
        } else if (jsonNode2.isArray()) {
            if (!jsonNode1.isArray() || jsonNode1.size() < jsonNode2.size()) {
                return false;
            }
            for (int i = 0; i < jsonNode2.size(); ++i) {
                if (this.containsProperties(jsonNode1.get(i), jsonNode2.get(i))) continue;
                return false;
            }
        } else {
            return jsonNode1.isValueNode() && jsonNode2.isValueNode();
        }
        return true;
    }

    private <T> Iterable<T> iterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    @Operation(summary="Verifies uniqueness of connector title")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns true or false in the result object", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/exists/{title}"})
    public ResponseEntity<?> titleExists(@PathVariable(value="title") String title) throws IOException {
        ResultDTO resultDTO = new ResultDTO();
        if (this.connectorService.existByTitle(title)) {
            resultDTO.setResult((Object)true);
        } else {
            resultDTO.setResult((Object)false);
        }
        return ResponseEntity.ok((Object)resultDTO);
    }
}

