/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.service.ComponentServiceImpl;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.ComponentResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Application Components", description="Manages operations related to Application Components management")
@RequestMapping(value={"/component"}, produces={"application/json"})
public class ComponentController {
    @Autowired
    private ComponentServiceImpl componentService;

    @Operation(summary="Retrieves all Components of Application.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application Components have been successfully retrieved.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ComponentResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/all"})
    public ResponseEntity<List<ComponentResource>> all() {
        List collection = this.componentService.findAll().stream().map(ComponentResource::new).collect(Collectors.toList());
        return ResponseEntity.ok(collection);
    }
}

